import { Card, CardActions, CardContent, Grid } from "@mui/material";
import { useLocation, useParams } from "react-router-dom";
import { useSelector, useDispatch } from "react-redux";
import { useEffect } from "react";
import { fetchProject } from "../../store/actions/projectsActions";

const FullProject = () => {
    const { projects, project } = useSelector(state => state.projects);

    const dispatch = useDispatch();
    console.log(projects);
    let location = useLocation();
    let point = location.pathname
    console.log(point.includes("admin"))
    const params = useParams()

    useEffect(() => {
        dispatch(fetchProject(params.id))
    }, [params.id, dispatch]);
    console.log(project)

    return <>
        <Grid item xs={12} sm={12} md={6} lg={4}>
            <Card>
                <h2>Проект - {project?.project?.title}</h2>
                <CardContent>
                    <strong>
                        <br></br>
                        Дата создания проекта: {project?.project?.createdAt}
                    </strong>
                    <strong>
                        <br></br>
                        Цвет: {project?.project?.color}
                    </strong>
                    <strong>
                        <br></br>
                        Админ проекта: {project?.project?.admin.name}
                    </strong>
                    <strong>
                        <br></br>
                        Задачи: {projects?.projects?.tasks?.map(task => {
                            return <>
                                <strong><br></br>Задача проекта: {task.title} </strong>
                            </>
                        })}
                    </strong>
                </CardContent>
                <CardActions>

                </CardActions>
            </Card>
        </Grid>

    </>
};

export default FullProject;
