import Box from '@mui/material/Box';
import Modal from '@mui/material/Modal';


export default function ModalTask({modal, handleClose, children}) {

  const style = {
    position: 'absolute',
    top: modal.yPage - modal.yDiv - modal.yDivClick,
    left: modal.xPage + modal.xDiv - modal.xDivClick + 10,
    width: 250,
    height: 350,
    bgcolor: 'background.paper',
    border: '2px solid #000',
    boxShadow: 24,
    p: 4,
  };
  return (
    <>
      <Modal
        open={modal.open}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
        BackdropProps={{ style: { backgroundColor: 'rgba(255,255,255, 0)' } }}
      >
        <Box sx={style}>
          {children}
        </Box>
      </Modal>
    </>
  );
}