import * as React from "react";
import {
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableRow,
  TableHead,
  IconButton,
  Tooltip,
  Typography,
  Divider,
} from "@mui/material";
import { useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { AddBox } from "@mui/icons-material";
import moment from "moment";
import CustomTableCell from "./CustomTableCell";
import MaterialUIPickers from "./DateTimePicker/DateTimePicker";
import BasicSelect from "../UI/Select/Select";
import { addTask } from "../../store/actions/tasksActions";

export default function NewTaskForm({projects,setAddTaskForm,tasks}) {
  
  const dispatch = useDispatch();
  const user = useSelector((state) => state.users.user);
  const currentDateTime = new Date();
  const dateTime = moment(currentDateTime).utc().format();

  const [task, setTask] = useState({
    id: 0,
    title: "",
    description: "",
    createdAt: dateTime,
    dateTimeStart: null,
    dateTimeDue: null,
    project: projects[0],
    accomplish: "opened",
    priority: "B",
    authorDisplayName: user.displayName,
    executors: [],
    isEditMode: true,
  });

  const onChange = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const newTask = { ...task, [name]: value };
    setTask(newTask);
  };

  const onProjectChange = (e, task) => {
    const value = e.target.value;
    const project = projects.find((e) => e.id === value);
    const newTask = { ...task };
    newTask.project = project;
    setTask(newTask);
  };

  const onDateChange = (id, value, property) => {
    const newTask = {
      ...task,
      [property]: moment.parseZone(value, "DD/MM/YYYY", true).format(),
    };
    setTask(newTask);
  };

  const handleAddTask = () => {
    dispatch(addTask(task));
    setAddTaskForm();
  };

  return (
    <>
      <Divider>
        <Typography variant="overline">Добавить новую задачу</Typography>
      </Divider>
      <TableContainer
        style={{
          backgroundColor: "#E8E8E8",
          display: "flex",
          alignItems: "center",
          marginBottom: "2em",
        }}
      >
        <Table sx={{ minWidth: 600 }} aria-labelledby="tableTitle">
          <TableHead>
            <TableRow>
              {header.map((headCell) => (
                <TableCell
                  key={headCell.id}
                  align="center"
                  padding={headCell.disablePadding ? "none" : "normal"}
                >
                  {headCell.label}
                </TableCell>
              ))}
            </TableRow>
          </TableHead>

          <TableBody>
            <TableRow hover key={task.id}>
              <TableCell component="th" scope="row" padding="none"></TableCell>
              <TableCell>
                <BasicSelect
                  items={[
                    { value: "A", title: "A" },
                    { value: "B", title: "B" },
                    { value: "C", title: "C" },
                  ]}
                  task={task}
                  value={task.priority}
                  onChange={onChange}
                  name="priority"
                />
              </TableCell>

              <CustomTableCell
                {...{
                  task,
                  name: "createdAt",
                  value: moment(task.createdAt).format("DD-MM-YYYY hh:mm A"),
                }}
              />

              <CustomTableCell
                {...{
                  task,
                  name: "title",
                  value: task.title,
                  onChange: onChange,
                  placeholder: "Введите название задачи",
                }}
              />
              <CustomTableCell
                {...{
                  task,
                  name: "description",
                  value: task.description,
                  onChange: onChange,
                  placeholder: "Введите описание задачи",
                }}
              />

              <TableCell>
                <BasicSelect
                  items={projects.map((e) => ({
                    value: e?.id,
                    title: e?.title,
                  }))}
                  task={task}
                  onChange={onProjectChange}
                  name="project"
                  value={task.project?.id}
                />
              </TableCell>

              <CustomTableCell
                {...{
                  task,
                  name: "author",
                  value: user.displayName,
                }}
              />

              <TableCell>
                <MaterialUIPickers
                  task={task}
                  name="dateTimeStart"
                  onChange={onDateChange}
                />
              </TableCell>

              <TableCell>
                <MaterialUIPickers
                  task={task}
                  name="dateTimeDue"
                  onChange={onDateChange}
                />
              </TableCell>

              <TableCell>
                <BasicSelect
                  items={[
                    { value: "opened", title: "opened" },
                    { value: "done", title: "done" },
                    { value: "failed", title: "failed" },
                  ]}
                  task={task}
                  onChange={onChange}
                  name="accomplish"
                  value={task.accomplish}
                />
              </TableCell>

              <TableCell>
                <Tooltip title="Добавить">
                  <IconButton size="large" onClick={handleAddTask}>
                    <AddBox fontSize="large" />
                  </IconButton>
                </Tooltip>
              </TableCell>
            </TableRow>
          </TableBody>
        </Table>
      </TableContainer>
      <Divider />
    </>
  );
}

export const header = [
  {
    id: "id",
    numeric: true,
    disablePadding: true,
    label: "",
  },
  {
    id: "priority",
    numeric: false,
    disablePadding: true,
    label: "Приоритет",
  },
  {
    id: "createdAt",
    numeric: true,
    disablePadding: false,
    label: "Дата создания",
  },
  {
    id: "title",
    numeric: false,
    disablePadding: false,
    label: "Заголовок",
  },
  {
    id: "description",
    numeric: false,
    disablePadding: false,
    label: "Описание",
  },

  {
    id: "projectName",
    numeric: true,
    disablePadding: false,
    label: "Проект",
  },
  {
    id: "authorDisplayName",
    numeric: false,
    disablePadding: false,
    label: "Автор",
  },
  {
    id: "dateTimeStart",
    numeric: true,
    disablePadding: false,
    label: "Дата начала",
  },
  {
    id: "dateTimeDue",
    numeric: true,
    disablePadding: false,
    label: "Дата завершения",
  },
  {
    id: "accomplish",
    numeric: false,
    disablePadding: false,
    label: "Статус",
  },
  {
    id: "add",
    numeric: false,
    disablePadding: false,
    label: "",
  },
];
