import * as React from "react";
import TextField from "@mui/material/TextField";
import { LocalizationProvider } from "@mui/x-date-pickers/LocalizationProvider";
import { DateTimePicker } from "@mui/x-date-pickers/DateTimePicker";
import { AdapterMoment } from "@mui/x-date-pickers/AdapterMoment";


export default function MaterialUIPickers(props) {
  return (
    <LocalizationProvider
      dateAdapter={AdapterMoment}
      sx={{ width: "auto", fontSize: 5, fontWeight: "200" }}
    >
      <DateTimePicker
        inputFormat="DD-MM-YYYY hh:mm A"
        disabled={props.task.readOnly}
        renderInput={(params) => (
          <TextField
            {...params}
            sx={{ width: "auto", fontWeight: "200", fontSize: 5 }}
            name={props.name}
          />
        )}
        value={props.task[props.name]}
        onChange={(newValue) => {
          props.onChange(props.task.id, newValue, props.name);
        }}
      />
    </LocalizationProvider>
  );
}
