import { Button, FormControl, InputLabel, MenuItem, Select, TextField } from "@mui/material";

function MonthCalendarModalContent({title, onChangeCurrentTaskHandler, description, priority, sendNewTaskHandler, deleteTaskHandler}) {
  return (<>
  <TextField 
    id="task-description-title" 
    value={title}
    label="Название" 
    variant="outlined" 
    sx={{marginBottom: '30px'}}
    name='title'
    onChange={(e)=>{onChangeCurrentTaskHandler(e)}}
  />
  <TextField 
    id="task-description" 
    multiline
    rows={4}
    value={description}
    label="Описание" 
    variant="outlined" 
    sx={{marginBottom: '30px'}} 
    name='description'
    onChange={(e)=>{onChangeCurrentTaskHandler(e)}}
  />
  <FormControl variant="outlined" sx={{width: '160px', marginBottom: '30px'}}>
    <InputLabel id="priority-type-label">Приоритет</InputLabel>
      <Select
        labelId="priority-type-label"
        id="priority-type"
        label="Приоритет"
        sx={{width: '160px'}}
        value={priority}
        name='priority'
        onChange={onChangeCurrentTaskHandler}
      >
        <MenuItem value={null}>
                <em>-- Выберите Приоритет --</em>
        </MenuItem>
        <MenuItem value={"A"}>A</MenuItem>
        <MenuItem value={"B"}>B</MenuItem>
        <MenuItem value={"C"}>C</MenuItem>
      </Select>
  </FormControl>
  <Button sx={{marginRight: '40px'}} onClick={sendNewTaskHandler}>Сохранить</Button>
  <Button onClick={deleteTaskHandler}>Удалить</Button>
  </>);
}

export default MonthCalendarModalContent;