import { Grid} from "@mui/material";
import { memo, useEffect, useState } from "react";
import DefaultTask from "../DefaultTask/DefaultTask";


  const cellClass = {
    transition: '0.3s',
    position: 'relative', 
    height: '35px',
  }

const CalendarStandartCell = ({children, xs, hours, dayNumber,  createTaskInCellHandler, handleOpen, modal, divRef, dragTaskHandler, linesInDay}) => {
    const [isThisCell, setIsThisCell] = useState(false)

    useEffect(()=>{
        if(!modal) {
            setIsThisCell(false);
        }
    }, [modal])

    const dragOverHandler = (e) => {
        e.preventDefault();
      }
    
    const dropHandler = (e) => {
        e.stopPropagation()
        e.preventDefault();
        dragTaskHandler(dayNumber, parseInt(hours.split(':')[0]))
    }

    return <>
        <Grid  
            item xs={xs} 
            sx={cellClass} 
            onClick={(e)=>{createTaskInCellHandler(dayNumber, hours); setIsThisCell(true); handleOpen(e)}}
            onDragOver={(e)=>{dragOverHandler(e)}}
            onDrop={(e)=>{dropHandler(e)}}
        >
            {children}
        {isThisCell ?  
        <DefaultTask/> : null}
        <div style={{position: 'absolute', height: children ? divRef : 0, width: '1px', backgroundColor: 'black', right: '0', top: '0', zIndex: '3'}}>

        </div>
        </Grid>
    </>
};

export default memo(CalendarStandartCell,  (prevProps, nextProps)=>{
    if(!prevProps.modal) return false
    if(nextProps.modal) return true
  });