import express,{Router, Request, Response} from 'express';
import {Project} from '../models/Project';
import {myDataSource} from '../app-data-source';
import { User } from '../models/User';
import { Member, MemberRole } from '../models/Member';
import { userInfo } from 'os';
import { Task } from '../models/Task';

const router:Router = express.Router();
const dataSource = myDataSource;


router.get('/',async (req:Request, res:Response): Promise<Response>=> {
    const projects:Project[] = await dataSource.manager.find(Project)
    return res.send({projects})
})

router.get('/my',async (req:Request, res:Response): Promise<Response>=> {
    const token = req.get('Authorization');
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.token = :token", { token: token })
    .getOne();
    if(!user) return res.status(404).send({Message:'user not found'})


    const rawProjects = await dataSource
    .createQueryBuilder()
    .from(Project, "project")
    .select(["project.id"])
    .leftJoinAndSelect('project.members', 'member')
    .loadRelationCountAndMap('project.tasks', 'project.tasks')
    .leftJoinAndSelect('member.user', 'user' )
    .where('member.userId = :userId',{userId:user.id})
    // .where("project.id = :id", { id: req.params.id })
    // .select(["*","members"])
    // .select("*") 
    .getMany()
    const projectIds = []
    if (rawProjects.length>0){
        for(let project of rawProjects){
            projectIds.push(project.id
                )
        }
    }
    console.log('projectIds', projectIds)
    const projects = await dataSource
    .createQueryBuilder()
    .from(Project, "project")
    .select(["project"])
    .leftJoinAndSelect('project.members', 'member')
    .loadRelationCountAndMap('project.tasks', 'project.tasks')
    .leftJoinAndSelect('member.user', 'user')
    .where('project.id IN(:...projectIds)', {projectIds})
    .getMany()
    // const projects:Project[] = await dataSource.manager.find(Project)
    return res.send({projects})
})


router.post('/', async (req:Request, res:Response): Promise<Response> => {
    if (!req.body) return res.status(400).send({Message:'problem in incoming req.body'})
    const token = req.get('Authorization');
    const {title,color}= req.body;
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.token = :token", { token: token })
    .getOne();
    if(!user) return res.status(404).send({Message:'user not found'})
    const member:Member = new Member;
    member.user= user;
    member.roleProject= MemberRole.ADMIN;
    await member.save();
    const project : Project= new Project()
    project.title = title;
    project.color = color; 
    project.members=[member]
    await project.save()
    return res.send({project})
})

router.get("/:id",async (req:Request, res:Response): Promise<Response> => {
    const project = await dataSource
    .createQueryBuilder()
    .select("project")
    .from(Project, "project")
    .leftJoinAndSelect('project.members', 'member')
    .leftJoinAndSelect('member.user', 'user' )
    .where("project.id = :id", { id: req.params.id })
    .getOne()
    if (!project) return res.status(404).send({Message:'no info on this project'})
    const tasks = await dataSource.getRepository('Task')
    .find(
        {
            relations:{
                executor:true,
                author:true,
            },
            where:{
                project:{
                    id:req.params.id
                }
            }
        }
    )
    return res.send({project, tasks})
})


router.delete('/:projectId',async (req: Request, res: Response):Promise<Response>=>{
    const projectId = req.params.projectId;
    await myDataSource
    .createQueryBuilder()
    .delete()
    .from(Project)
    .where("id = :id", { id: projectId })
    .execute()
    return res.send({message: 'Project deleted successfully'})

})


router.get('/user/:userId', async (req : Request, res : Response): Promise<Response>=>{
    const userId:string = req.params.userId
    const userProjects = await dataSource
    .createQueryBuilder()
    .select('project')
    .from(Project, "project")
    .where("project.admin = :id", { id: userId })
    .getMany();
    return res.send({userProjects})
})


/** Add user to specific project  */

router.post('/add-user/', async (req: Request, res: Response):Promise<Response>=>{
    const {userId, projectId, roleProject} = req.body;
    const newMember:Member = new Member();
    try{
    newMember.user= userId;
    newMember.project=projectId
    newMember.roleProject=roleProject
    await newMember.save()
    return res.send({newMember})
    } catch(e){
        return res.send({message:"add user to project failed" })
    }
    
})


/** Remove user from specific project  */

router.post('/remove-user', async (req: Request, res: Response):Promise<Response>=> {
    console.log('in delete user')
    const token = req.get('Authorization');
    console.log('token ', token)
    const {userId, projectId} = req.body;
    console.log('req.body', req.body )
    const adminOfProject =  await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .leftJoinAndSelect("user.membership","member")
    .leftJoinAndSelect('member.project', 'project' )
    .where("user.token = :token", { token })
    .andWhere('project.id=:projectId',{projectId})
    .andWhere('member.roleProject=:roleProject',{roleProject:'admin'})
    .getOne()
    if (!adminOfProject){
        return res.send({message:'User is not authorized'})
    } 
    // return res.send({adminOfProject})
    
    console.log('adminOfProject', adminOfProject)
    try{
        await dataSource
        .createQueryBuilder()
        .delete()
        .from(Member)
        .where("user = :userId", { userId })
        .andWhere("project=:projectId",{projectId})
        .execute()
    return res.send({message:"User removed from project successfully" })
    } catch(e){
        return res.send({message:'Failed to remove user from project'})
    }
}) 


export default router;
