import {
    Column,
    Entity,
    PrimaryGeneratedColumn,
    CreateDateColumn,
    BaseEntity,
    ManyToOne,
    ManyToMany,
    OneToMany,
    JoinTable
  } from 'typeorm';
  import {User} from './User';
  import {Project} from './Project';
  import {Task} from './Task';


  export enum MemberRole  {USER="user" ,WATCHER= "watcher",ADMIN="admin"}


  interface IMember{
    id: string;
    user: User;
    project: Project;
    createdAt: Date;
    roleProject: MemberRole;
  }


  @Entity({name:"Member"})
  export class Member extends BaseEntity implements IMember{
    @PrimaryGeneratedColumn("uuid")
    id!: string;
    
    @CreateDateColumn({ name: 'createdAt', type: Date, default: new Date() })
    createdAt!: Date;

    @ManyToOne(() => User, (user: { members: Member[]; }) => user.members,{cascade: true,  onUpdate:'CASCADE',eager:true})
    user!: User;

    @ManyToOne(() => Project, (project: { members: Member[]; }) => project.members,{cascade: true,  onUpdate:'CASCADE',nullable:true})
    project!: Project;

    @Column({
      type: "enum",
      enum: MemberRole,
      default: MemberRole.USER
    })
    roleProject!: MemberRole
    
  }