import { Grid, Typography, Button } from "@mui/material";
import { Link } from "react-router-dom";
import { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import Loader from "../../components/UI/Loader/Loader";
import HasAccess from "../../components/UI/HasAccess/HasAccess";
import { fetchProjects } from "../../store/actions/projectsActions";
import ProjectsList from "../../components/ProjectsList/ProjectsList";
import NewProject from "../NewProject/NewProject";

const Projects = () => {
    const dispatch = useDispatch();
    const { projects, loading } = useSelector(state => state.projects.projects);
    const {users} = useSelector(state => state.users);
    const members = useSelector(state => state.projects.projects)

    console.log(projects)
    console.log(users)
    useEffect(() => {
        dispatch(fetchProjects())
    }, [dispatch]);


    return <>
        {projects?.length > 0 ? (<>
            <Grid container direction="column" spacing={2}>
                <Grid
                    container
                    item
                    direction="row"
                    justifyContent="space-between"
                    alignItems="center"
                >
                    <Grid item>
                        <Typography variant="h4">
                            Проекты
                        </Typography>
                    </Grid>
                    <HasAccess roles={["superuser", "admin", "user"]} >
                        <Grid item>
                              <NewProject/>
                        </Grid>
                    </HasAccess>
                </Grid>
                <Loader loading={loading} />
                <ProjectsList projects={projects} members={members} />
            </Grid>
        </>) :
            <h1>Созданных проектов нет</h1>
        }
    </>
};

export default Projects;