import {Button} from "@mui/material";
import {NavLink} from "react-router-dom";
import { workerMenuButtons } from "../../../constants";
import ProfileBlock from "../ProfileBlock/ProfileBlock";

const WorkerMenu = () => {

    return <>
        {workerMenuButtons.map((button, i)=>{
            return(
                <Button
                    key={i}
                    component={NavLink}
                    to={button.path}
                    color="inherit"
                    size="large"
                >
                    {button.text}
                </Button>
            )
        })}
        
        <ProfileBlock/>
    </>
};

export default WorkerMenu;
