import { Box, Button, Grid, Modal } from "@mui/material";
import { useState } from "react";
import { useSelector } from "react-redux";
import FormElement from "../UI/Form/FormElement/FormElement";
import { Typography } from "@mui/material";
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Autocomplete from '@mui/material/Autocomplete';
import { useParams } from "react-router-dom";
import PersonAddIcon from '@mui/icons-material/PersonAdd';

const style = {
  position: 'absolute',
  top: '50%',
  left: '50%',
  transform: 'translate(-50%, -50%)',
  width: 400,
  bgcolor: 'background.paper',
  border: '2px solid #000',
  boxShadow: 24,
  p: 4,
};

const MemberForm = ({ onSubmit }) => {
  const users = useSelector(state => state.users.users)
  const [role, setRole] = useState([{ role: "user" }, { role: "admin" }, { role: "watcher" }])
  const params = useParams()
  console.log(users)
  const [open, setOpen] = useState(false);
  const handleOpen = () => setOpen(true);
  const handleClose = () => setOpen(false);
  const [state, setState] = useState({
    displayName: "",
    roleProject: "",
    userId: "",
    projectId: ""
  });

 
  const submitFormHandler = (e) => {
    e.preventDefault();
    let idOfUser = users?.map((user) => (user.displayName === state.displayName) ? user.id : null)
    let idOfUser1 = users?.map((user) => {
    console.log(user)
      return null
    })
    console.log(idOfUser1)
    console.log(idOfUser)
    console.log("state of submit " + state);
    let members = {roleProject: state.roleProject, projectId: params.id, userId: idOfUser }
    console.log(members);
    onSubmit(members);

  };

  // const onChange = (e) => {
  //   const value = e.target.value;
  //   const name = e.target.name;
  // const newState= { ...state, [name]: value };
  //   console.log("newState " + newState)
  //   console.log("e.target " + e.target)
  //   console.log("e " + e)
  //   setState(newState);
  // };

  const memberChangeHandler = (e, value) => {
    setState(() => { return { ...state, member: value, userId: state.userId} });
    console.log("memberChangeHandler" + value)
  }
  const roleChangeHandler = (e, value) => {
    setState(() => { return { ...state, roleProject: value } });
    console.log(value)
  }
  return (
    <div >
      <PersonAddIcon onClick={handleOpen} style={{marginLeft: "30px", marginTop: "-3px"}} >Добавить участника</PersonAddIcon>
      <Modal
        open={open}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
       
      >
        <Box sx={style}>
          <form  onSubmit={submitFormHandler}>
            <Grid container direction="column" spacing={2}>
              <Typography variant="h5" style={{margin: "5px", textAlign: "center"}} >Новый участник</Typography>
              <Autocomplete
                id="free-solo-demo"
                freeSolo
                options={users?.map((user) => user.displayName)}
                onChange={memberChangeHandler}
                name={"userId"}
                value={state.userId}
                renderInput={(params) => <TextField
                  style={{margin: "5px"}}
                  
                 
  
                  label={"Участник"}
                  state={state}
                  {...params} />}
              />
              <Autocomplete
                id="free-solo-demo"
                freeSolo
                options={role?.map((role) => role.role)}
                value={state.roleProject}
                onChange={roleChangeHandler}
                renderInput={(params) => <TextField
                  style={{margin: "5px"}}
                  name={"roleProject"}
                  
                  label={"Роль в проекте"}
                  state={state}
                  {...params} />}
              />
              <Grid item>
                <Button
                  type="submit"
                  color="primary"
                  variant="contained"

                >
                  Create
                </Button>
              </Grid>
            </Grid>
          </form>
        </Box>
      </Modal>
    </div>
  );

};

export default MemberForm;