import express, { NextFunction, Request, Response, Router } from "express";
import { myDataSource } from "./app-data-source";
import { Task } from "./models/Task";
import { User } from "./models/User";
import nodemailer from  'nodemailer';


const dataSource = myDataSource;

/** Check if user with given token exists , return user */
export const auth = async(req: Request,res: Response, next:NextFunction):Promise<void | express.Response<Response>>=>{
    const token = req.get('Authorization');
    if(!token) return res.status(401).send({Message:'token not exists'})
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.token = :token", { token: token })
    .getOne();
    if (!user) return res.status(404).send({Message:'user not found'})
    req.body={...req.body,user:user}
    next()
};

/**Check if user with the given token is executor or author of task with the given Id(taskId) */
export const authAuthorOrExecutorOfTask = async(req: Request,res: Response, next:NextFunction):Promise<void | express.Response<Response>>=>{
    const token = req.get('Authorization');
    let taskId = null
    taskId = req.body.taskId
    if (req.body?.taskId) {
        taskId = req.body.taskId
    } else if (req.params?.taskId){
        taskId = req.params.taskId
    } else return res.send({vessage:"there are no taskId found"})


    if(!token) return res.status(401).send({Message:'token not exists'})
    req.body={...req.body,executorStatus:false}
    req.body={...req.body,authorStatus:false}

    const task = await dataSource
    .getRepository(Task)
    .findOne({
        relations:{
            executor:true,
            author:true,           
        },
        where:[
            {
            id:taskId,
            executor:{
                token:token
            }
        },
        {
            id:taskId,
            author:{
                token:token
            }
        },
    ]})
    if (!task) return res.status(404).send({message:'task with possible user involved is not found'})
    if(task?.executor?.token === token) {
        req.body={...req.body,executorStatus:true}
    }
      if (task?.author?.token === token ) {
        req.body={...req.body,authorStatus:true}
    }
    next()
};


/**Check if user with the given token is executor or author of task with the given dateTimeTaskId */
export const authAuthorOrExecutorOfDateTimeTask = async(req: Request,res: Response, next:NextFunction):Promise<void | express.Response<Response>>=>{
    const token = req.get('Authorization');
    let dateTimeTaskId = null
    req.body={...req.body,executorStatus:false}
    req.body={...req.body,authorStatus:false}
    dateTimeTaskId = req.body.dateTimeTaskId
    if (req.body?.dateTimeTaskId) {
        dateTimeTaskId = req.body.dateTimeTaskId
    } else if (req.params?.dateTimeTaskId){
        dateTimeTaskId = req.params.dateTimeTaskId
    } else return res.send({vessage:"there are no dateTimeTaskId found"})
    const task = await dataSource
    .createQueryBuilder()
    .select(["task"])
    .from(Task,"task")
    .leftJoinAndSelect("task.executor","user")
    .leftJoinAndSelect("task.dateTimeTasks","dateTimeTask")
    .leftJoinAndSelect("task.author","users")
    .where("dateTimeTask.id = :dateTimeTaskId", {dateTimeTaskId})
    .getOne()
    if (!task) return res.status(404).send({message:'task with possible user involved is not found'})

    if(task?.executor?.token === token) {
        req.body={...req.body,executorStatus:true}
    }
      if (task?.author?.token === token ) {
        req.body={...req.body,authorStatus:true}
    }
    next()
}




/**task finder by id, return one task */
export const taskFinderById = async (taskId:string):Promise<null | Task>=>{
    const task = await dataSource
    .getRepository(Task)
    .findOne({
        relations:{
            executor:true,
            author:true,
            dateTimeTasks:true
        },
        where:{
            id:taskId
        }
    })
    return task
}



export let  transporter = nodemailer.createTransport({
    service:'Yandex',
    // host: "smtp.yandex.ru",
    // port: 465,
    // secure: true, // true for 465, false for other ports
    auth: {
      user: "planner45@yandex.ru", // generated ethereal user
      pass: "newPlannerProject123" // generated ethereal password
    }
  })
  


  export const FRONTEND_URL  = 'localhost:3000'