import { Button, TextField } from "@mui/material";
import { Box } from "@mui/system";
import { memo } from "react";
import { isValidate } from "./helpers";


const NewProjectModalContent = ({ inputChangeHandler, projectTitle, createNewProjectHandler, handleClose }) => {


  return <>
    <TextField
      onChange={(e) => { inputChangeHandler(e) }}
      name={"title"}
      label={"Название"}
      value={projectTitle}
      id="project-title"
      variant="outlined"
      sx={{width: '100%'}}
    />
    <Box sx={{ display: 'flex', justifyContent: 'space-between', marginTop: '10px' }}>
      <Button
        type="submit"
        color="primary"
        variant="outlined"
        onClick={() => { createNewProjectHandler() }}
        disabled={!isValidate(projectTitle)}
      >
        Создать
      </Button>
      <Button
        type="submit"
        color="primary"
        variant="outlined"
        onClick={() => { handleClose() }}
      >
        Отмена
      </Button>
    </Box>
  </>
};

export default memo(NewProjectModalContent);