import { TablePagination } from "@mui/material";
import { memo } from "react";


function MyTasksTablePagination({count, rowsPerPage, page, handleChangePage, handleChangeRowsPerPage}) {

  return (
    <TablePagination
      rowsPerPageOptions={[5, 10, 25]}
      component="div"
      count={count}
      rowsPerPage={rowsPerPage}
      page={page}
      onPageChange={handleChangePage}
      onRowsPerPageChange={handleChangeRowsPerPage}
    />
  );
}

export default memo(MyTasksTablePagination)