import { 
  ADD_NEW_TASK_FAILURE, 
  ADD_NEW_TASK_REQUEST, 
  ADD_NEW_TASK_SUCCESS, 
  DELETE_TASK_FAILURE, 
  DELETE_TASK_REQUEST, 
  DELETE_TASK_SUCCESS, 
  EDIT_TASK_FAILURE, 
  EDIT_TASK_REQUEST, 
  EDIT_TASK_SUCCESS, 
  FETCH_CALENDAR_TASKS_FAILURE, 
  FETCH_CALENDAR_TASKS_REQUEST, 
  FETCH_CALENDAR_TASKS_SUCCESS,
  FETCH_ALL_TASKS_SUCCESS,
  FETCH_TASKS_BY_PROJECT_SUCCESS,
  FETCH_TASKS_BY_PROJECT_FAILURE,
  FETCH_TASKS_BY_PROJECT_REQUEST
  } from "../actionTypes/tasksTypes";
import axios from '../../axiosPlanner'

const fetchCalendarTasksRequest = () => {
  return {type: FETCH_CALENDAR_TASKS_REQUEST}
};

const fetchCalendarTasksSuccess = (tasks) => {
  return {type: FETCH_CALENDAR_TASKS_SUCCESS, tasks}
};

const fetchAllTasksSuccess = (tasks) => {
  return {type: FETCH_ALL_TASKS_SUCCESS, tasks}
};


const fetchCalendarTasksFailure = (error) => {
  return {type: FETCH_CALENDAR_TASKS_FAILURE, error}
};

export const fetchCalendarTasks = () => {
  return async (dispatch) => {
      dispatch(fetchCalendarTasksRequest());
      try {
        const response = await axios.get("/tasks");
        dispatch(fetchCalendarTasksSuccess(response.data.tasks))
      } catch (error) {
        dispatch(fetchCalendarTasksFailure(error.response.data));
      }
  }
};

export const fetchAllTasks = () => {
  return async (dispatch) => {
      dispatch(fetchCalendarTasksRequest());
      try {
        const response = await axios.get("/tasks");
           dispatch(fetchAllTasksSuccess(response.data.tasks))
      } catch (error) {
        dispatch(fetchCalendarTasksFailure(error.response.data));
      }
  }
};
const addTaskRequest = () => {
  return {type: ADD_NEW_TASK_REQUEST}
};

const addTaskSuccess = () => {
  return {type: ADD_NEW_TASK_SUCCESS}
};

const addTaskFailure = (error) => {
  return {type: ADD_NEW_TASK_FAILURE, error}
};

export const addCalendarTask = (task) => {
  return async (dispatch) => {
      dispatch(addTaskRequest());
      try {
        const response = await axios.post("/tasks", task);
        dispatch(addTaskSuccess())
        dispatch(fetchCalendarTasks())
      } catch (error) {
        dispatch(addTaskFailure(error.response.data));
      }
  }
}

export const addCopyCalendarTask = (task) => {
  return async (dispatch) => {
      dispatch(addTaskRequest());
      try {
        const response = await axios.post("/copy-tasks/make-copy", task);
        dispatch(addTaskSuccess())
        dispatch(fetchCalendarTasks())
      } catch (error) {
        dispatch(addTaskFailure(error.response.data));
      }
  }
}

export const addTask = (task) => {
  return async (dispatch) => {
      dispatch(addTaskRequest());
      try {
        await axios.post("/tasks", task);
        dispatch(addTaskSuccess())
        dispatch(fetchAllTasks())
      } catch (error) {
        dispatch(addTaskFailure(error.response.data));
      }
  }
}

const editTaskRequest = () => {
  return {type: EDIT_TASK_REQUEST}
};

const editTaskSuccess = () => {
  return {type: EDIT_TASK_SUCCESS}
};

const editTaskFailure = (error) => {
  return {type: EDIT_TASK_FAILURE, error}
};

export const editTask = (task) => {
  return async (dispatch) => {
      dispatch(editTaskRequest());
      try {
        await axios.put("/tasks", task);
        dispatch(editTaskSuccess())
        dispatch(fetchAllTasks())
      } catch (error) {
        dispatch(editTaskFailure(error.response.data));
      }
  }
}

export const editCalendarTask = (task) => {
  return async (dispatch) => {
      dispatch(editTaskRequest());
      try {
        await axios.put("/copy-tasks/change-copy", task);
        dispatch(editTaskSuccess())
        dispatch(fetchCalendarTasks())
      } catch (error) {
        dispatch(editTaskFailure(error.response.data));
      }
  }
}

const deleteTaskRequest = () => {
  return {type: DELETE_TASK_REQUEST}
};
 
const deleteTaskSuccess = () => {
  return {type: DELETE_TASK_SUCCESS}
};

const deleteTaskFailure = (error) => {
  return {type: DELETE_TASK_FAILURE, error}
};

export const deleteTask = (taskId) => {
  return async (dispatch) => {
      dispatch(deleteTaskRequest());
      try {
        await axios.delete(`/tasks/${taskId}`);
        dispatch(deleteTaskSuccess())
        dispatch(fetchAllTasks())
      } catch (error) {
        dispatch(deleteTaskFailure(error.response.data));
      }
  }
}

export const deleteCalendarTask = (taskId) => {
  return async (dispatch) => {
      dispatch(deleteTaskRequest());
      try {
        await axios.delete(`/copy-tasks/${taskId}`);
        dispatch(deleteTaskSuccess())
        dispatch(fetchCalendarTasks())
      } catch (error) {
        dispatch(deleteTaskFailure(error.response.data));
      }
  }
}



const fetchTasksByProjectRequest = () => {
  return {type: FETCH_TASKS_BY_PROJECT_REQUEST}
};

const fetchTasksByProjectSuccess = () => {
  return {type: FETCH_TASKS_BY_PROJECT_SUCCESS}
};

const fetchTasksByProjectFailure = (error) => {
  return {type: FETCH_TASKS_BY_PROJECT_FAILURE, error}
};

export const fetchTasksByProject = (projects) => {
  return async (dispatch) => {
      dispatch(fetchTasksByProjectRequest());
      try {
        const response =await axios.post("/tasks/project", projects);
        dispatch(fetchTasksByProjectSuccess(response.data.tasks))
      } catch (error) {
        dispatch(fetchTasksByProjectFailure(error.response.data));
      }
  }
}