import axios from "../../axiosPlanner";
import { CREATE_PROJECT_SUCCESS, FETCH_PROJECTS_ERROR, FETCH_PROJECTS_REQUEST, FETCH_PROJECTS_SUCCESS, FETCH_PROJECT_SUCCESS } from "../actionTypes/projectsActionTypes";
import { showNotification } from "./commonActions";

const fetchProjectsRequest = () => {
    return {type: FETCH_PROJECTS_REQUEST}
};
const fetchProjectsSuccess = (projects) => {
    return {type: FETCH_PROJECTS_SUCCESS, projects};
};
const fetchProjectSuccess = (project) => {
    return {type: FETCH_PROJECT_SUCCESS, project};
};
const fetchProjectsError = (error) => {
    return {type: FETCH_PROJECTS_ERROR, error};
}

const createProjectSuccess = () => {
    return {type: CREATE_PROJECT_SUCCESS};
};

export const fetchProjects = () => {
    return async dispatch => {
        dispatch(fetchProjectsRequest());
        try {
            const response = await axios.get("/projects");
                dispatch(fetchProjectsSuccess(response.data));
        } catch(e) {
            dispatch(fetchProjectsError(e));
        }
    };
};

export const fetchProject = (id) => {
    return async dispatch => {
        dispatch(fetchProjectsRequest());
        try {
            const response = await axios.get("/projects/" + id);
            dispatch(fetchProjectSuccess(response.data));
        } catch (e) {
            dispatch(fetchProjectsError(e));
        }
    }
};

export const createProject = (projectData, navigate) => {
    return async (dispatch) => {
        try {
           const response = await axios.post("/projects", projectData);
            dispatch(createProjectSuccess());
            console.log(response.data)
           navigate("/projects/" + response.data.project.id)
            dispatch(showNotification("Проект успешно создан"))
        } catch (e) {
            console.log(e);
            dispatch(showNotification("Не удалось создать проект", "error"))
        }
    };
}