export const getDaysInMonth = (dateNow) => {
  if (dateNow.month <= 11 && dateNow.month >= 0) {
    const newDaysInMonth = []
    const daysInMonthNumber = new Date(dateNow.year, dateNow.month + 1, 0).getDate()
    for (let i = 1; i <= daysInMonthNumber; i++) {
      const dayOfWeekNumber = new Date(dateNow.year, dateNow.month, i).getDay()
      const getDayOfWeekString = ["ВС","ПН","ВТ","СР","ЧТ","ПТ","СБ"][dayOfWeekNumber]
      newDaysInMonth.push({dayNumber: i, dayOfWeek: getDayOfWeekString})
    }
    return newDaysInMonth
  } else {
    return null
  }
}

export const getCurrentMonthString = (dateNow) => {
  if (dateNow.month <= 11 && dateNow.month >= 0) {
    return ["Январь","Февраль","Март","Апрель","Май","Июнь","Июль","Август","Сентябрь","Октябрь","Ноябрь", "Декабрь"][dateNow.month];
  } else {
    return null
  }
}

export const dateToISOLikeButLocal = (date) => {
  if (date instanceof Date && !isNaN(date)) {
    const offsetMs = date.getTimezoneOffset() * 60 * 1000;
    const msLocal =  date.getTime() - offsetMs;
    const dateLocal = new Date(msLocal);
    const iso = dateLocal.toISOString();
    return iso;
  } else {
    return null
  }
}