import { Card, CardActions, CardContent, Grid } from "@mui/material";
import { useParams } from "react-router-dom";
import { useSelector, useDispatch } from "react-redux";
import { useEffect } from "react";
import { fetchProject } from "../../store/actions/projectsActions";
import ProjectTasksBody from "../../components/ProjectTasks/ProjectTasksBody";
import { fetchUsers } from "../../store/actions/usersActions";
import ProjectMembersList from "../../components/ProjectMembersList/ProjectMembersList";

const FullProject = () => {

    const { projects, project } = useSelector(state => state.projects);
    const users = useSelector(state => state.users.users);
    
    
    const dispatch = useDispatch();
    const params = useParams()
    const tasks = project.tasks;
    console.log(projects);
    console.log(tasks);

    useEffect(() => {
        dispatch(fetchUsers())
    }, [dispatch]);
    
    console.log(users)

    useEffect(() => {
        dispatch(fetchProject(params.id))
    }, [params.id, dispatch]);
    console.log(project);

    return <>
        <Grid item xs={12} sm={12} md={6} lg={4}>
            <Card>
                <h2>Проект - {project?.project?.title}</h2>
                <CardContent>
                    <strong>
                        <br></br>
                        Дата создания проекта: {project?.project?.createdAt}
                    </strong>
                    <strong>
                        <br></br>
                        Цвет: {project?.project?.color}
                    </strong>
                    <strong>
                        <br></br>
                        Автор проекта: {project?.project?.members[0]?.user.displayName}
                    </strong>
                    <strong>
                        <br></br>
                        Роль в проекте: {project?.project?.members[0]?.roleProject}
                    </strong>
                    <strong>
                        <br></br>
                        Участники проекта: 
                        
                        <ProjectMembersList users={users} project={project}/>
                    </strong>
                    <strong>
                        <br></br>
                        Задачи:
                        <br></br>
                    </strong>
                    <strong>
                        <br></br>
                        <ProjectTasksBody
                            tasks={tasks}
                        />
                    </strong>
                </CardContent>
                <CardActions>
                </CardActions>
            </Card>
        </Grid>

    </>
};

export default FullProject;
