import { Grid} from "@mui/material";
import { memo, useEffect, useState } from "react";
import DefaultTask from "../DefaultTask/DefaultTask";



const CalendarStandartCell = ({children, xs, hours, dayNumber,  createTaskInCellHandler, handleOpen, modal, dragTaskHandler, linesInDay}) => {
    const [isThisCell, setIsThisCell] = useState(false)
    const cellClass = {
        position: 'relative', 
        height: linesInDay?.length ? `${40*linesInDay.length+35}px` : `${35}px`,
        borderRight: '1px solid black',
    }
    useEffect(()=>{
        if(!modal) {
            setIsThisCell(false);
        }
    }, [modal])

    const dragOverHandler = (e) => {
        e.preventDefault();
      }
    
    const dropHandler = (e) => {
        e.stopPropagation()
        e.preventDefault();
        dragTaskHandler(dayNumber, parseInt(hours.split(':')[0]))
    }
    const onClickHandler = (e) => {
        if (!linesInDay?.length) {
            createTaskInCellHandler(dayNumber, hours); 
            setIsThisCell(true); 
            handleOpen(e)
        }
    }

    return <>
        <Grid  
            item xs={xs} 
            sx={cellClass} 
            onClick={(e)=>{onClickHandler(e)}}
            onDragOver={(e)=>{dragOverHandler(e)}}
            onDrop={(e)=>{dropHandler(e)}}
        >
            {children}
        {isThisCell ?  
        <DefaultTask/> : null}
        
        </Grid>
    </>
};

export default memo(CalendarStandartCell,  (prevProps, nextProps)=>{
    if(!prevProps.modal) return false
    if(nextProps.modal) return true
  });