import express,{Router, Request, Response } from 'express';
import {Task} from '../models/Task';
import {myDataSource} from '../app-data-source';
import { User } from '../models/User';
import { Member } from '../models/Member';
import { In } from 'typeorm';
import { DateTimeTask } from '../models/DateTimeTask';
import { auth, authAuthorOrExecutorOfTask, taskFinderById } from '../helpers';
const router:Router = express.Router();
const dataSource = myDataSource;


/**get all tasks */
router.get('/', async(req:Request, res:Response):Promise<Response> => {
    const tasks = await dataSource
.getRepository(Task)
.find({
    relations:{
        executor:true,
        author:true,
    }})
    return res.send({tasks})
})


/**create new task */
router.post('/', auth, async(req:Request, res:Response):Promise<Response>=>{
    const {user,title,description,project,executor,dateTimeStart,dateTimeDue, dateTimeDeadLine,priority} = req.body;
    const newTask = new Task();
    newTask.title = title;
    newTask.description = description;
    newTask.project = project;
    newTask.dateTimeDeadLine=dateTimeDeadLine;
    newTask.author= user;
    newTask.executor= executor;
    newTask.priority = priority;
    await newTask.save(); 
    const newDateTimeTask = new DateTimeTask();
        newDateTimeTask.dateTimeStart = dateTimeStart
        newDateTimeTask.dateTimeDue = dateTimeDue
        newDateTimeTask.task = newTask
        await newDateTimeTask.save()
    return res.send({newTask});
})


/**check tasks of specific user by userID */
router.get('/user/:userId', async (req: Request, res: Response):Promise<Response>=>{   
    const userId = req.params.userId;
    const tasks = await dataSource
    .getRepository(Task)
    .find({
        relations:{
            executor:true,
            author:true,
        },
    where:[
        {
        executor:{
            id:userId
        }
    },
    {
        author:{
            id:userId
        }
    },
]
})
    return res.send({tasks})
})


/**check tasks of current user where he is author or executor, search by id*/
router.get('/my',auth, async (req: Request, res: Response):Promise<Response>=>{
    const user = req.body.user
    const tasks = await dataSource
    .getRepository(Task)
    .find({
        relations:{
            executor:true,
            author:true,
        },
    where:[
        {
        executor:{
            id:user.id
        }
    },
    {
        author:{
            id:user.id
        }
    },
]
})
    return res.send({tasks})
})


/**return tasks & users of projects in which current user is involved, search by token*/
router.get('/related', auth,async (req: Request, res: Response):Promise<Response>=>{
    console.log('related')
    const user = req.body.user
    const tasks = await dataSource
    .createQueryBuilder()
    .select(["task"])
    .from(Task,"task")
    .leftJoinAndSelect("task.executor","user")
    .leftJoinAndSelect("task.dateTimeTasks","dateTimeTask")
    .leftJoinAndSelect("task.author","users")
    .leftJoinAndSelect("task.project","project")
    .leftJoinAndSelect("project.members", "member")
    .where("member.userId = :userId", {userId:user.id})
    .getMany()

     let projectIds:any[] = []
    if (tasks.length>0){
        for (let task of tasks){
            const projectId = task?.project?.id
            projectIds.push(projectId)
        }
    }
    const projectsIdArray = [...new Set(projectIds)]; 
    let users:User[]=[]
    if (projectIds.length>0){
    users = await dataSource
   .getRepository(User)
.find({
        relations:{
        members:true,
        },
        where:{
        members:
            {project:In(
                projectsIdArray
            )}
        }
    })
}
    return res.send({tasks, users})
})


/**delete of task by task id */
router.delete('/:taskId',async (req: Request, res: Response):Promise<Response>=>{
    const taskId = req.params.taskId;
    await myDataSource
    .createQueryBuilder()
    .delete()
    .from(Task)
    .where("id = :id", { id: taskId })
    .execute()
    return res.send({message: 'Task deleted successfully'})

})


/**change of task  by task id */
router.put('/',authAuthorOrExecutorOfTask,async(req:Request, res:Response)=> {
    const {authorStatus,executorStatus,taskId,title,description,note, archive,project,dateTimeTaskId,dateTimeStart,dateTimeDue,executor,accomplish,dateTimeDeadLine, dateTimeFactDeadLine,priority} = req.body;
    const task = await taskFinderById(taskId)
    if (!task) return res.status(404).send({Message:'task not found'})
    let dateTimeTask = null;
    if (dateTimeTaskId) {
        const dateTimeTaskData = await dataSource
        .createQueryBuilder()
        .select("dateTimeTask")
        .from(DateTimeTask, "dateTimeTask")
        .where("dateTimeTask,id=:dateTimeTaskId",{dateTimeTaskId})
        .getOne()
        if (!dateTimeTask) return res.status(404).send({Message:'dateTimeTask not found'})
        dateTimeTask = dateTimeTaskData
    }

        if (dateTimeTask!==null) {
            dateTimeTask.dateTimeStart = dateTimeStart
            dateTimeTask.dateTimeDue = dateTimeDue
            await dateTimeTask.save()
    }   
    
    if (authorStatus){
        task.title = title
        task.description= description
        task.archive=archive
        task.dateTimeDeadLine=dateTimeDeadLine;
        task.project=project
        task.executor=executor
        task.priority= priority   
    }
    if(executorStatus){
        task.note = note
        task.dateTimeFactDeadLine= dateTimeFactDeadLine
    }
    task.accomplish= accomplish
    await task.save()
    res.send({message:'update task successfully'})
})


/** search all tasks on given projects: project Id array[] */
router.post('/project',async (req: Request, res: Response):Promise<Response>=>{
    let projectArray :string[]= req.body;
    if (projectArray.length===0) {
        const rawTasks = await
        dataSource
       .getRepository(Task)
        .find({
            relations:{
                executor:true,
                author:true,
                project:true
            }
        })
    const tasks:object[]= rawTasks.filter(task=>task.project===null)
       return res.send({tasks})
    } 
    const tasks = await
     dataSource
    .getRepository(Task)
    .createQueryBuilder('task')
    .innerJoinAndSelect( 'task.project', 'project')
    .where('task.project IN(:...projects)', {projects:projectArray})
    .getMany()
    return res.send({tasks})
}) 





export default router;
