import express,{Router, Request, Response,NextFunction } from 'express';
import {Task} from '../models/Task';
import {myDataSource} from '../app-data-source';
import { User } from '../models/User';
import { Member } from '../models/Member';
import { In } from 'typeorm';
import { DateTimeTask } from '../models/DateTimeTask';
import { auth, authAuthorOrExecutorOfTask } from '../helpers';
const router:Router = express.Router();
const dataSource = myDataSource;

/**task finder by id, return one task */
const taskFinderById = async (taskId:string):Promise<null | Task>=>{
    const task = await dataSource
    .getRepository(Task)
    .findOne({
        relations:{
            executor:true,
            author:true,
            dateTimeTasks:true
        },
        where:{
            id:taskId
        }
    })
    
    return task
}

/** make copy of task in calendar view */
router.post("/make-copy", async(req:Request, res:Response):Promise<Response>=>{
    const {taskId, dateTimeDue, dateTimeStart} = req.body
    const newDateTimeTask = new DateTimeTask();
    newDateTimeTask.dateTimeStart = dateTimeStart
    newDateTimeTask.dateTimeDue = dateTimeDue
    newDateTimeTask.task = taskId
    await newDateTimeTask.save()
    const task = taskFinderById(taskId)
    return res.send({task})

} )

/** change date time of copy of task in calendar view */
router.put("/change-copy", authAuthorOrExecutorOfTask, async(req:Request, res: Response):Promise<Response>=>{
    const {dateTimeTaskId, taskId, dateTimeStart, dateTimeDue, description, title, priority} = req.body
    const dateTimeTask = await dataSource
    .createQueryBuilder()
    .select('dateTimeTask')
    .from(DateTimeTask,'dateTimeTask')
    .where("dateTimeTask.id = :dateTimeTaskId",{dateTimeTaskId})
    .getOne()
    if(!dateTimeTask) return res.send({message:"such dateTimeTask does not exists"})
    dateTimeTask.dateTimeStart=dateTimeStart
    dateTimeTask.dateTimeDue=dateTimeDue
    await dateTimeTask.save()
    const task = await taskFinderById(taskId)
    if (!task) return res.status(404).send({Message:'task not found'})
    task.title = title;
    task.description = description;
    task.priority = priority;
    await task.save()
    return res.send({task}) 
})

/**delete copyTask by dateTimeTaskId */
router.delete('/:id', authAuthorOrExecutorOfTask, async(req:Request, res:Response):Promise<Response>=>{
 const {id} = req.params
    await myDataSource
    .createQueryBuilder()
    .delete()
    .from(DateTimeTask)
    .where("id = :id", { id })
    .execute()
    return res.send({message:"delete succesfully"})
}
)

export default router;
