import {
    Column,
    Entity,
    PrimaryGeneratedColumn,
    CreateDateColumn,
    BaseEntity,
    ManyToOne,
    ManyToMany,
    OneToMany,
    JoinTable
  } from 'typeorm';
  // import {User} from './User';
  import {Task} from './Task';
  import {Member} from './Member';



  interface IProject{
    id: string;
    title: string;
    color: string;
    tasks:Task[]|null;
    createdAt: Date;
    active:boolean;
    members: Member[];
  }

  @Entity({ name: 'Project' })
  export class Project extends BaseEntity implements IProject{

    @PrimaryGeneratedColumn('uuid')
    id!: string

    @Column({ name: 'title', type: 'varchar', length:100,nullable: false})
    title!: string

    @CreateDateColumn({ name: 'createdAt', type: Date, default: new Date() })
    createdAt!: Date;

    @Column({ name: 'color', type: 'varchar', length:100,nullable: true })
    color!: string;

    @Column({ name: 'active',type: 'boolean', default: true })
    active!: boolean;

    @OneToMany(() => Task, (task: { project: Project; })=>task.project,{nullable:true})
    tasks!:Task[];

    @OneToMany(() => Member, (member: { project: Project; })=>member.project)
    members!:Member[];
 
 }