import { Divider, IconButton, TableCell, TableRow, Tooltip } from "@mui/material";
import moment from "moment";
import { memo, useCallback, useMemo, useState } from "react";
import DeleteButton from "../../../../UI/DeleteButton/DeleteButton";
import { Done, Edit } from "@mui/icons-material";
import { useSelector } from "react-redux";
import CalendarMonthIcon from '@mui/icons-material/CalendarMonth';
import { Box } from "@mui/system";
import KeyboardArrowDownIcon from '@mui/icons-material/KeyboardArrowDown';
import KeyboardArrowUpIcon from '@mui/icons-material/KeyboardArrowUp';
import TableForCopiesTasks from "./TableForCopiesTasks/TableForCopiesTasks";
import EditRow from "./EditRow/EditRow";

const editClass = {
  cursor: 'pointer',
  transition: '0.5s',
  "&:hover": {

    transition: '0.5s',
    transform: 'scale(1.2)'
  }
}

function MyTasksRow({ row, deleteTaskHandler, calendarOpen, deleteCopyTaskHandler, currentTask, isEdit, setIsEdit, setCurrentTask, onChangeCurrentTaskHandler, allUserProjectsForModalTask, onDateChangeEditHandler, editCurrentTaskHandler }) {
  const user = useSelector((state) => state.users.user);

  const [openCopies, setOpenCopies] = useState(false);
  const [editMode, setEditMode] = useState(false);

  const dateTimeTasks = useMemo(() => {
    if (row?.dateTimeTasks?.length === 1) {
      const date = moment(row.dateTimeTasks[0].dateTimeStart).utc().format('DD.MM')
      const start = moment(row.dateTimeTasks[0].dateTimeStart).utc().format('HH:mm')
      let end
      if (new Date(row.dateTimeTasks[0].dateTimeDue).getMinutes() === 59 ) {
        end = moment(row.dateTimeTasks[0].dateTimeDue).utc().add(1, 'minutes').format('HH:mm')
      } else {
        end = moment(row.dateTimeTasks[0].dateTimeDue).utc().format('HH:mm')
      }
      const diff = parseInt(end.split(':')[0]) - parseInt(start.split(':')[0])
      return <Box sx={{ width: '90%', display: 'flex' }}>
        <Tooltip title={moment(row.dateTimeTasks[0].dateTimeStart).utc().format('YYYY')}>
          <Box>
            {`${date} (${start} - ${end})`}
            <Divider sx={{ opacity: 0 }} />
            {`часы: ${diff}`}
          </Box>
        </Tooltip>

        {user.id === row?.executor?.id ?
          <Tooltip title="Перейти в календарь">
            <IconButton
              sx={{ marginLeft: '5px' }}
              onClick={() => { calendarOpen(row) }}
            >
              <CalendarMonthIcon />
            </IconButton>
          </Tooltip>
          : null
        }

      </Box>
    } else if (row?.dateTimeTasks?.length > 1) {
      return (<>
        <IconButton
          aria-label="expand row"
          size="small"
          onClick={() => setOpenCopies(prevState => !prevState)}
        >
          {openCopies ? <KeyboardArrowUpIcon /> : <KeyboardArrowDownIcon />}
        </IconButton>
        {
          user.id === row?.executor?.id ?
            <Tooltip title="Перейти в календарь">
              <IconButton
                sx={{ marginLeft: '5px' }}
                onClick={() => { calendarOpen(row) }}
              >
                <CalendarMonthIcon />
              </IconButton>
            </Tooltip>
            : null
        }
      </>)
    } else if (row?.dateTimeTasks?.length === 0) {
      return (<>
        Копий нет
        {
          user.id === row?.executor?.id ?
            <Tooltip title="Перейти в календарь">
              <IconButton
                sx={{ marginLeft: '5px' }}
                onClick={() => { calendarOpen(row) }}
              >
                <CalendarMonthIcon />
              </IconButton>
            </Tooltip>
            : null
        }
      </>)
    }
  }, [user.id, calendarOpen, row, openCopies])

  const onClickEditButtonHandler = useCallback(() => {
    if (!editMode) {
      setCurrentTask({
        ...row,
        project: { ...row.project },
        executor: { ...row.executor }
      })
    } else {
      editCurrentTaskHandler()
      setCurrentTask({
        priority: '',
        title: '',
        project: '',
        description: '',
        executor: '',
      })
    }
    setEditMode((prevState) => !prevState)
    setIsEdit((prevState) => !prevState)
  }, [setIsEdit, editMode, row, setCurrentTask, editCurrentTaskHandler])


  const buttons = useMemo(() => {
    if (!editMode && isEdit) return null
    if (editMode) {
      return <Done sx={editClass} onClick={() => { onClickEditButtonHandler() }} />
    } else {
      if (user.id === row?.author?.id) {
        return (<>
          <Edit sx={{ ...editClass, position: 'absolute', left: -10 }} onClick={() => { onClickEditButtonHandler() }} />
          <DeleteButton onClick={() => { deleteTaskHandler(row.id) }} />
        </>)
      } else if (user.id === row?.executor?.id) {
        return (<Edit sx={editClass} onClick={() => { onClickEditButtonHandler() }} />)
      } else {
        return null
      }
    }
  }, [deleteTaskHandler, row, user.id, editMode, isEdit, onClickEditButtonHandler])


  return (<>
    <TableRow
      hover
      key={row.id}
    >
      {editMode ?
        <>
          <EditRow
            buttons={buttons}
            dateTimeTasks={dateTimeTasks}
            onChangeCurrentTaskHandler={(e) => { onChangeCurrentTaskHandler(e) }}
            currentTask={currentTask}
            allUserProjectsForModalTask={allUserProjectsForModalTask}
            onDateChangeEditHandler={onDateChangeEditHandler}
            user={user}
          />
        </>
        :
        <>
          <TableCell sx={{ width: '4%' }}>{row.priority ? row.priority : null}</TableCell>
          <TableCell sx={{ width: '10%' }}>{moment(row.createdAt).format('DD.MM.YYYY')}</TableCell>
          <Tooltip title={row.description}>
            <TableCell sx={{ width: '28%' }}>
              {row.title}
            </TableCell>
          </Tooltip>
          <TableCell sx={{ width: '12%' }}>{row.projectTitle}</TableCell>
          <TableCell sx={{ width: '11%' }}>{row.authorName}</TableCell>

          <TableCell sx={{ width: '13%' }}>
            {dateTimeTasks}
          </TableCell>

          <TableCell sx={{ width: '12%' }}>{row.dateTimeDeadLine ? moment(row.dateTimeDeadLine).utc().format('DD.MM.YYYY HH:mm') : null}</TableCell>
          <TableCell sx={{ width: '7%' }}>
            {row.accomplishTranslate}
          </TableCell>
          <TableCell size='medium' sx={{ width: '5%', position: 'relative' }}>
            {buttons}
          </TableCell>
        </>}

    </TableRow>
    {row.dateTimeTasks.length ? <TableForCopiesTasks
      task={row}
      openCopies={openCopies}
      user={user}
      deleteCopyTaskHandler={deleteCopyTaskHandler}
    /> : null}


  </>)
}

export default memo(MyTasksRow)