import axios from "../../axiosPlanner";
import { LOGIN_USER_FAILURE, LOGIN_USER_SUCCESS, LOGOUT_USER_FAILURE, LOGOUT_USER_SUCCESS, REGISTER_USER_FAILURE, REGISTER_USER_REQUEST, REGISTER_USER_SUCCESS } from "../actionTypes/actionTypes"
import { showNotification } from "./commonActions";

const registerUserRequest = () => {
    return {type: REGISTER_USER_REQUEST}
};

const registerUserSuccess = () => {
    return {type: REGISTER_USER_SUCCESS}
};

const registerUserFailure = (error) => {
    return {type: REGISTER_USER_FAILURE, error}
};

export const registerUser = (userData, navigate) => {
    return async (dispatch) => {
        dispatch(registerUserRequest());
        try {
           const response = await axios.post("/users", userData);
            dispatch(registerUserSuccess())
            navigate("/")
        } catch (error) {
            if (error.response?.data) {
                dispatch(registerUserFailure(error.response.data));
            } else {
                dispatch(registerUserFailure({global: "Потеряно соедиение"}));
            }
        }
    }
}

const loginUserSuccess = (user) => {
    return {type: LOGIN_USER_SUCCESS, user}
}

const loginUserFailure = (error) => {
    return {type: LOGIN_USER_FAILURE, error}
}
const logoutUserSuccess = () => {
    return {type: LOGOUT_USER_SUCCESS}
}

const logoutUserFailure = (error) => {
    return {type: LOGOUT_USER_FAILURE, error}
}

export const loginUser = (userData, navigate) => {
    return async (dispatch) => {
        try {
            const response = await axios.post("users/sessions", userData);
            dispatch(loginUserSuccess(response.data));
            navigate("/")
        } catch (e) {
            dispatch(loginUserFailure(e?.response?.data?.err))
        }
    }
}

export const logoutUser = (navigate) => {
    return async (dispatch, getState) => {
        try {
            await axios.delete("/users/sessions", {
                headers: {
                    'Authorization': getState().users.user?.token
                }
            });
            dispatch(logoutUserSuccess());
            navigate("/");
            dispatch(showNotification("Вы успешно вышли"));
        } catch (e) {
            dispatch(logoutUserFailure(e?.response?.data));
            dispatch(showNotification("Не удалось выйти", "error"));
        }
    } 
}