import { Container } from '@mui/material';
import { useEffect, useState } from 'react';
import MonthCalendarBody from '../../components/MonthCalendarBody/MonthCalendarBody';
import MonthCalendarHeader from '../../components/MonthCalendarHeader/MonthCalendarHeader';

function MonthCalendar() {
  const [month, setMonth] = useState('')
  const [year, setYear] = useState('')
  const [worker, setWorker] = useState('');
  const [calendarType, setCalendarType] = useState('Месяц');

  
  useEffect(()=>{
    setMonth(new Date().getMonth())
    setYear(new Date().getFullYear())
  },[])
  const onChangeWorkerHandler = (event) => {
    setWorker(event.target.value);
  };

  const onChangeCalendarTypeHandler = (event) => {
    setCalendarType(event.target.value);
  };

  const getCurrentMonthString = (month) => {
    return ["Январь","Февраль","Март","Апрель","Май","Июнь","Июль","Август","Сентябрь","Октябрь","Ноябрь", "Декабрь"][month];
  }

  const incrementMonth = () => {
    setMonth((prevState)=>{
      if (prevState + 1 === 12 ) { 
        setYear(prevState=>prevState+1)
        return 0 
      }
      return prevState + 1
    })
  }

  const decrementMonth = () => {
    setMonth((prevState)=>{
      if (prevState - 1 === -1) {
        setYear(prevState=>prevState-1)
        return 11
      }
      return prevState - 1 
    })
  }

  return (
    <>
    <Container>
      <MonthCalendarHeader
        month={month}
        year={year}
        getCurrentMonthString={getCurrentMonthString} 
        decrementMonth={decrementMonth}
        incrementMonth={incrementMonth}
        onChangeCalendarTypeHandler={onChangeCalendarTypeHandler}
        onChangeWorkerHandler={onChangeWorkerHandler}
        worker={worker}
        calendarType={calendarType}
      />
      <MonthCalendarBody
        month={month}
        year={year}
      />
    </Container>
    </>
  );
}

export default MonthCalendar;
