import { Button, Grid} from "@mui/material";
// import { NavLink } from "react-router-dom";
import FormElement from "../UI/Form/FormElement/FormElement";

const UserForm = ({ state, onChange, onSubmit, getFieldError, buttonText, resetPassword }) => {
    return <form onSubmit={onSubmit}>
        <Grid container spacing={2}>
            <FormElement
                onChange={onChange}
                name="email"
                label="Email"
                state={state}
                error={getFieldError?.("email")}
            />
            <FormElement
                onChange={onChange}
                name="password"
                label="Password"
                type="password"
                state={state}
                error={getFieldError?.("password")}
            />
        </Grid>
        <Button
            sx={{ mt: "15px" }}
            type="submit"
            fullWidth
            variant="contained"
            color="primary"
        >
            {buttonText}
        </Button>
        {/* <Button
            component={NavLink}
            to={"/forgottenpassword"}
            sx={{ mt: "15px" }}
            type="submit"
            fullWidth
            variant="contained"
            color="primary"
        >
            {resetPassword}
        </Button> */}
    </form>
}

export default UserForm;