import * as React from 'react';
import Box from '@mui/material/Box';
import InputLabel from '@mui/material/InputLabel';
import MenuItem from '@mui/material/MenuItem';
import FormControl from '@mui/material/FormControl';
import Select from '@mui/material/Select';

export default function BasicSelect(props) {
  
  const [taskContent, setTaskContent] = React.useState(props.task.accomplish);

  const handleChange = (event) => {
    setTaskContent(event.target.value);
  };

  React.useEffect(() => {
    if (props.task !== null) {
      setTaskContent({
        accomplish: props.task.accomplish,
         });
    }
  }, [props.task]);
  

  const inputChangeHandler = (e) => {
    const { name, value } = e.target;
    console.log(e.target)
    setTaskContent((prevState) => {
      return { ...prevState, [name]: value };
    });
    props.onChange(e, props.task);
  };


console.log(props)
  return (
    <Box sx={{ minWidth: 60}}>
      <FormControl fullWidth>
        <InputLabel id="demo-simple-select-label"></InputLabel>
        <Select
          labelId="demo-simple-select-label"
          id="demo-simple-select"
          value={taskContent?.accomplish}
          label=""
          name={"accomplish"}
          onChange={inputChangeHandler}
          sx={{ marginTop: 2}}
        //  className={'disabled'}
        >
          <MenuItem value={props.itemOne}>{props.itemOne}</MenuItem>
          <MenuItem value={props.itemTwo}>{props.itemTwo}</MenuItem>
          <MenuItem value={props.itemThree}>{props.itemThree}</MenuItem>
        </Select>
      </FormControl>
    </Box>
  );
}