import * as React from 'react';
import TextField from '@mui/material/TextField';
import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
import { DateTimePicker } from '@mui/x-date-pickers/DateTimePicker';
import { useState, useEffect } from "react";
import dayjs from 'dayjs';
import { AdapterMoment } from "@mui/x-date-pickers/AdapterMoment";

export default function MaterialUIPickersDue(props) {
 
console.log(props)

  return (
    <LocalizationProvider dateAdapter={AdapterMoment}>
    <DateTimePicker
     readOnly={props.readOnly}
      renderInput={(params) => (
        <TextField {...params} name="dateCreated" />
      )}
      value={
        props.newDueDate && props.newDueDate.id === props.task.id? props.newDueDate.date
          : props.task.dateTimeDue
      }
      onChange={(newValue) => {
        props.setNewDueDate({
          id: props.task.id,
          date: newValue,
        });
      }}
    />
  </LocalizationProvider>
  );

}