import * as React from 'react';
import TextField from '@mui/material/TextField';
import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
import { DateTimePicker } from '@mui/x-date-pickers/DateTimePicker';
import { useState, useEffect } from "react";
import dayjs from 'dayjs';
import { AdapterMoment } from "@mui/x-date-pickers/AdapterMoment";

export default function MaterialUIPickers(props) {
  
  return (
    <LocalizationProvider dateAdapter={AdapterMoment}  sx={{ width: "auto", fontSize:5,fontWeight: "200" }}>
    <DateTimePicker
      readOnly={props.readOnly}
      renderInput={(params) => (
        <TextField {...params}
        sx={{ width: "auto",fontWeight: "200",fontSize: 5 }}
        name="dateCreated" />
      )}
      value={
        props.newStartedDate && props.newStartedDate.id === props.task.id? props.newStartedDate.date
          : props.task.dateTimeStart
      }
      onChange={(newValue) => {
        props.setNewStartedDate({
          id: props.task.id,
          date: newValue,
        });
      }}
    />
  </LocalizationProvider>
  );

}