import * as React from 'react';
import TableCell from '@mui/material/TableCell';
import IconButton from '@mui/material/IconButton';
import Input from '@mui/material/Input';
import { Done, CalendarToday } from '@mui/icons-material';
import MaterialUIPickers from './DateTimePicker/DateTimePicker';


const  CustomTableCell = ({ task, name, onChange, onModalOpen }) => {

  const styles = { width: "auto", height: "40px" };

  return (
    <>
{task.isEditMode && name === "title" ? (
    <TableCell 
    onClick={(e) => onModalOpen(e, task)} align="left" style={styles}>
        <Input
          value={task[name]}
          name={name}
          onChange={(e) => onChange(e, task)}
          style={styles}
        />
    </TableCell>
      ) : task.isEditMode && name !== "title"? (
        <TableCell align="left" style={styles}>
        <Input
          value={task[name]}
          name={name}
          onChange={(e) => onChange(e, task)}
          style={styles}
        />
        </TableCell>
      ) : onModalOpen ? (
        <TableCell align="left" style={styles} onClick={(e) => onModalOpen(e, task)}>
        <span style={{ width: "100%" }} >
          {task[name]}
        </span>
        </TableCell>
      ) : (
        <TableCell align="left" style={styles}>
        {task[name]}
        
        </TableCell>
      )}
</>
  );
};


export default  CustomTableCell;

 