import express,{Router, Request, Response} from 'express';
import {User} from '../models/User';
import {myDataSource} from '../app-data-source';
import { nanoid } from 'nanoid';

const router:Router = express.Router();
const dataSource = myDataSource;

router.get('/', async (req : Request, res : Response):Promise<object> => {
const users = await dataSource
.getRepository(User)
    .createQueryBuilder("user")
    .getMany()
return res.send({users})
})


router.post('/', async (req : Request, res : Response):Promise<object> => {

    const {name,surname,password,email} = req.body;
    const displayName = surname+' '+name[0]+'.'
    const user = new User();
    user.name = name;
    user.surname = surname;
    user.password = password;
    user.displayName= displayName;
    user.email = email;
    user.generateToken()
    await user.save();
    const userToFront:User|null = await dataSource.manager.findOneBy(User, {
        email: user.email
    })
    return res.send({userToFront})
})


router.post('/sessions/', async (req : Request, res : Response):Promise<object> => {
    const {email, password} = req.body;
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.email = :email", { email: email })
    .getOne()
    if(!user) return res.status(404).send({Message:'user not found'})

    const isMatch:boolean = await user.checkPassword(password);
    if (!isMatch) return res.status(400).send({
        error: "Wrong Password"
    })
 
    const userToFront:User|null = await dataSource.manager.findOneBy(User, {
        email: req.body.email
    })
    return res.send({
                message: "message: 'Correct user  & password",
                user: userToFront
            })
})


router.delete('/sessions', async(req: Request, res: Response):Promise<void | object> => {
    const token = req.get('Authorization');
    const successMsg = {message:'success'};
    if(!token) return res.send(successMsg)
    const user = await dataSource.manager.findOneBy(User, {
        token: token
    })
    if(!user) return res.send({successMsg});
    console.log('token: ' + token)
    user.token = nanoid();
    await user.save();
   
})



export default router;


