import * as React from 'react';
import Table from '@mui/material/Table';
import TableBody from '@mui/material/TableBody';
import TableCell from '@mui/material/TableCell';
import TableContainer from '@mui/material/TableContainer';
import TableHead from '@mui/material/TableHead';
import TableRow from '@mui/material/TableRow';
import Paper from '@mui/material/Paper';

const SwitchUserTable=({projectsRoles})=>{

    return (

        <TableContainer component={Paper}>
        <Table sx={{ minWidth: 350 }} aria-label="simple table">
          <TableHead>
            <TableRow>
              <TableCell 
              sx ={{ 
            'backgroundColor':'black',
            'color': 'white'
                    }}
                    >Проекты</TableCell>
              <TableCell  
              sx ={{ 
            'backgroundColor':'black',
            'color': 'white'
                    }} align="right"
                    >Роли</TableCell>
            </TableRow>
          </TableHead>
          <TableBody>
            {projectsRoles.map((projectRole,index) =>{  return (
              
              <TableRow
                key={index}
                sx={{ '&:last-child td, &:last-child th': { border: 0 } }}
              >
                <TableCell component="th" scope="row">
                  {projectRole.projectName}
                </TableCell>
                <TableCell align="right">{projectRole.roleName}</TableCell>
              </TableRow>
            )})}
          </TableBody>
        </Table>
      </TableContainer>
)

}
export default SwitchUserTable ;
