import { Grid } from "@mui/material";
import { memo, useCallback, useEffect, useMemo, useState } from "react";
import DefaultTask from "../DefaultTask/DefaultTask";

const heightCell = 40
const CalendarStandartCell = ({ children, xs, hours, dayNumber, createTaskInCellHandler, handleOpen, modal, dragTaskHandler, linesInDay, week, copyTask, createCopyTask, month, year, copyMode, copyModeTask }) => {
    const [isThisCell, setIsThisCell] = useState(false)
    const [top, setTop] = useState(0)
    const isDeadLine = useMemo(()=>{
        if (copyTask?.dateTimeDeadLine) {
            if (new Date(copyTask?.dateTimeDeadLine).getTime() - new Date(year, month, dayNumber, parseInt(hours?.split(':')[0])).getTime() < 0 ) {
                return true
            }
        } else {
            if (copyModeTask?.dateTimeDeadLine) {
                if (new Date(copyModeTask?.dateTimeDeadLine).getTime() - new Date(year, month, dayNumber, parseInt(hours?.split(':')[0])).getTime() < 0 ) {
                    return true
                }
            } else {
                return false
            }
        }
    },[copyTask, copyModeTask, year, month, dayNumber, hours])

    const cellClass = useMemo(() => {
        const backgroundColor = isDeadLine ? '#fa9b9be3' : 'null'
        return ({
            position: 'relative',
            height: linesInDay?.length ? `${heightCell * linesInDay.length + 5}px` : `${45}px`,
            borderRight: '1px solid black',
            borderBottom: week ? '1px solid black' : null,
            padding: week ? '2px' : null,
            transition: week ? '0.3s' : null,
            backgroundColor: backgroundColor,
            '&:hover': {
                transition: '0.3s',
                cursor: children ? null : '#d6d2d2',
                background: children ? null : '#d6d2d2'
            }
        })
    }, [children, linesInDay?.length, week, isDeadLine])


    useEffect(() => {
        if (!modal) {
            setIsThisCell(false);
        }
    }, [modal])

    const dragOverHandler = useCallback((e) => {
        e.preventDefault();
        e.target.style.background = children ? null : '#d6d2d2'
    }, [children])
    const dragLeaveHandler = useCallback((e) => {
        e.preventDefault();
        e.target.style.background = null
    }, [])

    const dropHandler = useCallback((e) => {
        e.stopPropagation()
        e.preventDefault();
        e.target.style.background = null
        dragTaskHandler(dayNumber, parseInt(hours.split(':')[0]), month, year)
    }, [dayNumber, hours, month, year, dragTaskHandler])

    const onClickHandler = useCallback((e) => {
        if (!week) {
            if (e.nativeEvent.offsetY <= 5) {
                setTop(40 * Math.ceil((e.nativeEvent.offsetY) / 40 - 1))
            } else {
                setTop(40 * Math.ceil((e.nativeEvent.offsetY - 5) / 40 - 1))
            }
        }
        if (copyTask || copyMode) {
            createCopyTask(dayNumber, parseInt(hours.split(':')[0]), month, year)
        } else {
            createTaskInCellHandler(dayNumber, hours, month, year);
            setIsThisCell(true);
            handleOpen(e)
        }
    }, [week, copyTask, copyMode, dayNumber, hours, month, year, createTaskInCellHandler, createCopyTask, handleOpen])

    const returnCells = useMemo(() => {
        if (copyTask || copyMode) {
            if (isDeadLine) {
                return (<Grid
                    item xs={xs}
                    sx={cellClass}
                >
                </Grid>)
            } else {
                return (<Grid
                    item xs={xs}
                    sx={cellClass}
                    onClick={(e) => { onClickHandler(e) }}
                    onDragOver={(e) => { dragOverHandler(e) }}
                    onDragLeave={(e) => { dragLeaveHandler(e) }}
                    onDrop={(e) => { dropHandler(e) }}
                >
                    {children}
                    {isThisCell ?
                        <DefaultTask week={week} top={top} /> : null}
                </Grid>)
            }
        }
        return (<>
            <Grid
                item xs={xs}
                sx={cellClass}
                onClick={(e) => { onClickHandler(e) }}
                onDragOver={(e) => { dragOverHandler(e) }}
                onDragLeave={(e) => { dragLeaveHandler(e) }}
                onDrop={(e) => { dropHandler(e) }}
            >
                {children}
                {isThisCell ?
                    <DefaultTask week={week} top={top} /> : null}

            </Grid>
        </>)

    }, [cellClass, children, copyMode, copyTask, dragOverHandler, dropHandler, isThisCell, onClickHandler, top, week, xs, dragLeaveHandler, isDeadLine])

    return <>
        {returnCells}
    </>
};

export default memo(CalendarStandartCell, (prevProps, nextProps) => {
    if (!prevProps.modal) return false
    if (nextProps.modal) return true
});