
import { Box, Typography } from '@mui/material';
import { memo } from 'react';
import ArrowDecrementButton from '../../../../UI/ArrowDecrementButton/ArrowDecrementButton';
import ArrowIncrementButton from '../../../../UI/ArrowIncrementButton/ArrowIncrementButton';
function MonthAndYearInfo({ currentMonthString, year, incrementMonth, decrementMonth }) {

  return (
    <>
      <Box
        sx={{
          flexGrow: 1,
          display: 'flex',
          alignItems: 'center',
          gap: '10px',
          marginBottom: '20px'
        }}
        id='test_month_info'
      >
        <ArrowDecrementButton
          onClick={decrementMonth}
        />
        <Box sx={{ flexBasis: '150px' }}>
          <Typography
            variant="h5"
            sx={{
              display: 'flex',
              justifyContent: 'center',
            }}
          >
            {currentMonthString}
          </Typography>
          <Typography align='center'>{year}</Typography>
        </Box>
        <ArrowIncrementButton
          onClick={incrementMonth}
        />
      </Box>
    </>);
}

export default memo(MonthAndYearInfo);