import { Grid } from "@mui/material";
import { useCallback, useEffect, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { createProject, fetchProjects } from "../../store/actions/projectsActions";
import FullProject from "../FullProject/FullProject";
import ProjectsWrapper from "../../components/ProjectsComponents/ProjectsWrapper/ProjectsWrapper";
import { useNavigate } from "react-router-dom";
import DefaultModal from "../../components/UI/DefaultModal/DefaultModal";
import NewProjectModalContent from "../../components/ProjectsComponents/NewProjectModalContent/NewProjectModalContent";

const Projects = () => {
    const { projects } = useSelector(state => state.projects.projects);
    const { user } = useSelector(state => state.users)

    const dispatch = useDispatch();
    const navigate = useNavigate()

    const [currentProject, setCurrentProject] = useState(null)
    const [projectTitle, setProjectTitle] = useState('');
    const [modal, setModal] = useState(false)

    useEffect(() => {
        dispatch(fetchProjects())
    }, [dispatch]);

    const inputChangeHandler = (e) => {
        setProjectTitle(e.target.value)
    };

    const onClickProjectHandler = useCallback((project) => {
        setCurrentProject(project)
    }, [])

    const onClickGoToSpecificProjectHandler = useCallback((e, projectId) => {
        e.stopPropagation();
        navigate(`/projects/${projectId}`)
    }, [navigate])

    const createNewProjectHandler = useCallback(() => {
        console.log({ title: projectTitle, user: user.id })
        dispatch(createProject({ title: projectTitle, user: user.id }, navigate))
    }, [dispatch, projectTitle, user.id, navigate])

    const handleOpen = useCallback(async () => {
        setModal(true)
    }, [])

    const handleClose = useCallback(() => {
        setModal(false)
    }, [])




    return <>
        <Grid container justifyContent='space-between'>

            <ProjectsWrapper
                projects={projects}
                onClickProjectHandler={onClickProjectHandler}
                onClickGoToSpecificProjectHandler={onClickGoToSpecificProjectHandler}
                handleOpen={handleOpen}
            />

            <Grid item xs={7}  >
                {currentProject ? <FullProject projectId={currentProject?.id} /> : null}
            </Grid>

        </Grid>

        <DefaultModal
            modal={modal}
            handleClose={() => { handleClose() }}
        >
            <NewProjectModalContent
                handleClose={handleClose}
                projectTitle={projectTitle}
                inputChangeHandler={inputChangeHandler}
                createNewProjectHandler={createNewProjectHandler}
            />
        </DefaultModal>
    </>
};

export default Projects;