import { Modal, IconButton } from "@mui/material";
import "./TaskModal.css";
import { Done } from "@mui/icons-material";
import Input from "@mui/material/Input";
import TextField from "@mui/material/Input";

const TaskModal = ({handleClose,open,task,onChange,user }) => {

  return (
    <Modal
      aria-labelledby="modal-modal-title"
      aria-describedby="modal-modal-description"
      BackdropProps={{ style: { backgroundColor: 'rgba(255,255,255, 0)' } }}
      closeAfterTransition
      onClose={handleClose}
      open={open}
    >
      {task?.isEditMode && task.author.id===user.id ? (
        
        <div className="modal">
          <Input
           label="название"
           color="secondary" 
            value={task.title}
            name="title"
            onChange={(e) => onChange(e, task)}
            style={{
              width: "auto",
              fontWeight: "600",
              height: "40px",
              fontWeight: "600",
              width:"280px",
              margin:"10px",
              padding:"5px",
              border: '2px solid #D3D3D3',
              borderRadius:"5px"
            }}
          />
          <TextField
            label="описание"
            value={task.description}
            name="description"
            onChange={(e) => onChange(e, task)}
            multiline={true}
            sx={{
            fontWeight: "400",
            width:"280px",
            margin:"10px",
            padding:"5px",
            border: '2px solid #D3D3D3',
            borderRadius:"5px",
            height:"300px",
            whiteSpace:"normal"
            }}
               />
          <IconButton aria-label="done" onClick={handleClose}
           sx={{margingBottom:"5px",marginTop:"auto"}}>
            <Done />
          </IconButton>
        </div>
      ) : (
        <div className="modal">
          {task && task.title && (
            <div
              style={{
               height: "40px",
               fontWeight: "600",
               width:"280px",
               margin:"10px",
               padding:"5px",
               border: '2px solid #D3D3D3',
               borderRadius:"5px"
              }}
            >
              {task.title}
            </div>
          )}
          {task && task.description && (
            <div 
            style={{margin:"10px",
                    border: '2px solid #D3D3D3',
                    borderRadius:"5px",
                    width:"280px",
                    height: "200px",
                    margin:"10px",
                    padding:"5px",
               }}>
              {task.description}
            </div>
          )}
          <IconButton
            aria-label="close"
            onClick={handleClose}
            sx={{margingBottom:"5px",marginTop:"auto"}}
          >
            X
          </IconButton>
        </div>
      )}
    </Modal>
  );
};

export default TaskModal;
