import {Grid} from "@mui/material";
import { memo } from "react";
import ProjectItem from "./ProjectItem/ProjectItem";

const ProjectsList = ({projects, onClickProjectHandler, onClickGoToSpecificProjectHandler}) => {
    return (
        <Grid item container gap={3} sx={{ height: '79vh', overflow: 'auto', overflowX: 'hidden'}}>
            {projects?.map(project => {
                return <ProjectItem
                    title={project.title}
                    members={project.members}
                    key={project.id}
                    onClickProjectHandler={()=>{onClickProjectHandler(project)}}
                    onClickGoToSpecificProjectHandler={(e)=>{onClickGoToSpecificProjectHandler(e, project.id)}}
                />
            })}
        </Grid>
    );
};

export default memo(ProjectsList);