import {Grid, Typography } from "@mui/material";
import { useSelector } from "react-redux";
import { memo, useMemo } from "react";
import DeleteButton from "../../../../UI/DeleteButton/DeleteButton";
import ArrowIncrementButton from "../../../../UI/ArrowIncrementButton/ArrowIncrementButton";

const styleBlock = {
    border: '2px solid black',
    borderRadius: '5px',
    width: '100%',
    padding: '15px',
    height: '10%',
}

const styleText = {
    fontSize: '15px',
    fontWeight: '600',
}

const ProjectItem = ({ title, members, onClickProjectHandler, onClickGoToSpecificProjectHandler }) => {

    const { user } = useSelector(state => state.users);
    const currentRoleInProject = useMemo(() => {
        return members.find((member) => member.user.id === user.id)?.roleProject
    }, [members, user.id])

    return <>
        <Grid item container xs={12} onClick={onClickProjectHandler} sx={styleBlock} justifyContent={'space-between'} alignItems={'center'}>
            <Grid item>
                <Typography sx={styleText}>
                    Проект: {title}
                </Typography>
                <Typography sx={styleText}>
                    Роль в проекте: {currentRoleInProject}
                </Typography>
            </Grid>
            <Grid item>
                <DeleteButton />
                <ArrowIncrementButton onClick={onClickGoToSpecificProjectHandler}/>
            </Grid>
        </Grid>
    </>
};

export default memo(ProjectItem);
