import { Grid } from "@mui/material";
import DeleteIcon from "@mui/icons-material/Delete";
import { memo } from "react";
import { useSelector } from "react-redux";

const style = {
    width: '90%',
    border: '1px solid black',
    borderRadius: '5px',
    padding: '15px 15px',
    display: 'flex',
    justifyContent: 'space-between',
    alignItems: 'center'
}

const ProjectMembersItem = ({ user, deleteMemberHandler, currentRoleInProject, dragMemberToNewRole, setCurrentMember, role }) => {
    const userId = useSelector(state => state.users.user.id);

    const dragStartHandler = (e) => {
        setCurrentMember(user)
      }
    
      const dragEndHandler = (e) => {
        setCurrentMember(null)
      }
    
      const dragOverHandler = (e) => {
        e.preventDefault();
      }
    
      const dropHandler = (e) => {
        e.preventDefault();
        dragMemberToNewRole(role)
      }
    
      const dragLeaveHandler = (e) => {
        e.preventDefault();
      }

    return <>
        <Grid sx={style}
            draggable={user.id !== userId ? true : false}
            onDragStart={(e) => { dragStartHandler(e) }}
            onDragEnd={(e) => { dragEndHandler(e) }}
            onDrop={(e) => { dropHandler(e) }}
            onDragOver={(e) => { dragOverHandler(e) }}
            onDragLeave={(e) => { dragLeaveHandler(e) }}

        >
            {user?.displayName}
            {currentRoleInProject === 'admin' && user.id !== userId ?
                <DeleteIcon
                    sx={{ cursor: 'pointer' }}
                    onClick={deleteMemberHandler}
                />
                : null}
        </Grid>
    </>
};

export default memo(ProjectMembersItem);
