import { Box, Typography } from "@mui/material";
import moment from "moment";
import { memo } from "react";
import PersonAddIcon from '@mui/icons-material/PersonAdd';
import ArrowIncrementButton from "../../UI/ArrowIncrementButton/ArrowIncrementButton";

const style = {
  display: 'flex',
  flexDirection: 'column',
}
const styleText = {
  fontSize: '20px',
  fontWeight: '600',
  display: 'flex',
  alignItems: 'center',
  gap: '10px'
}


const ProjectInfo = ({ project, handleOpen, currentRoleInProject,onClickTasksHandler }) => {
  return (
    <Box sx={style} justifyContent={'space-between'}>
      <Typography variant="h2">Проект - {project?.title} </Typography>
      <Typography variant="body1" sx={styleText}>
        Дата создания проекта: {moment(project?.createdAt).format('MM.DD.YYYY')}
      </Typography>
      <Typography variant="body1" sx={styleText}>
        Цвет: {project?.color || 'Зеленый'}
      </Typography>
      <Typography variant="body1" sx={styleText}>
        Автор проекта: {project?.members[0]?.user.displayName}
      </Typography>
      <Typography variant="body1" sx={styleText}>
        Роль в проекте: {currentRoleInProject}
      </Typography>
      <Typography variant="body1" sx={styleText}>
        Задачи: <ArrowIncrementButton onClick={()=>{onClickTasksHandler()}}/>
      </Typography>
      {currentRoleInProject === 'admin' ?
        <Typography variant="body1" sx={styleText}>
          Добавить участника:  <PersonAddIcon style={{ cursor: 'pointer' }} onClick={() => { handleOpen() }} />
        </Typography>
        : null
      }

    </Box>
  );
};

export default memo(ProjectInfo);