import * as React from "react";
import {
  TableCell,
  TableRow,
  IconButton,
  Tooltip,
  Collapse,
  Box,
  Table,
  TableBody,
  TableHead,
  Typography
  
} from "@mui/material";
import { Done, Edit } from "@mui/icons-material";
import RemoveIcon from '@mui/icons-material/Remove';
import DeleteIcon from "@mui/icons-material/Delete";
import moment from "moment";
import CustomTableCell from "../CustomTableCell";
import MaterialUIPickers from "../DateTimePicker/DateTimePicker";
import BasicSelect from "../../UI/Select/Select";
import CalendarMonthIcon from '@mui/icons-material/CalendarMonth';
import KeyboardArrowDownIcon from '@mui/icons-material/KeyboardArrowDown';
import KeyboardArrowUpIcon from '@mui/icons-material/KeyboardArrowUp';
import { useNavigate } from "react-router-dom";
import { useDispatch } from "react-redux";
import { activateCreateCopyTasksMode } from "../../../store/actions/tasksActions";

const weekDays = ["Вс","Пн","Вт","Ср","Чт","Пт","Сб" ];

const TableRowTask= ({
  user,
  task,
  deleteHandle,
  handleEditTask, 
  deleteDateTimeTask,
  onChange,
  onModalOpen,
  onProjectChange,
  uniqueProjects,
  onAuthorChange,
  onDateChange,
  onToggleEditMode,
  onToggleEditModeDone,
})=>{
  
  const [open, setOpen] = React.useState(false);
  const navigate = useNavigate()
  const dispatch = useDispatch()
  const roudHourUp =(dateIso)=>{
    let m = moment(dateIso);
    let roundUp = m.minute() || m.second() || m.millisecond() ? m.add(1, 'hour').startOf('hour') : m.startOf('hour');
    return roundUp
  }

  const timeTransform = (dateIso)=>{
    const exp  = roudHourUp(moment.utc(dateIso)).format("HH:"+"00")
    return exp;
  }
  
  const getDayOfWeek = (dateIso) => {
    const date = moment.utc(dateIso);
     return weekDays[date.day()];
  }
  const calendarOpen=(taskId)=>{
    dispatch(activateCreateCopyTasksMode(task, navigate))
  }

    return (
        <>
         <TableRow hover key={task.id}>
       
                          <TableCell
                          component="th"
                          scope="row"
                          padding="none"
                        ></TableCell> 
                       
                        {task.isEditMode && task.author.id===user.id  ? (
                          <TableCell>
                            <BasicSelect
                              items={[
                                { value: "A", title: "A" },
                                { value: "B", title: "B" },
                                { value: "C", title: "C" },
                              ]}
                              task={task}
                              value={task.priority}
                              onChange={onChange}
                              name="priority"
                              user={user}
                            />

                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "priority",
                              value: task.priority,
                              user:user
                            }}
                          />
                        )}

                        <CustomTableCell
                          {...{
                            task,
                            name: "createdAt",
                            value: moment(task.createdAt)
                              .utc()
                              .format("DD-MM-YY"),
                              user:user
                          }}
                        />

                        <CustomTableCell
                          {...{
                            task,
                            name: "title",
                            value: task.title,
                            onChange,
                            onModalOpen,
                            user:user
                          }}
                        />
                       
                       {task.isEditMode && task.author.id===user.id  ? (
                          <TableCell>
                            <BasicSelect
                              items={uniqueProjects.map((e) => ({
                                value: e?.id,
                                title: e?.title,
                              }))}
                              task={task}
                              onChange={onProjectChange}
                              name="project"
                              value={task.project?.id}
                              user={user}
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "projectId",
                              value: task.project?.title,
                              user:user
                            }}
                          />
                        )}

                



                        <CustomTableCell
                          {...{
                            task,
                            name: "author",
                            value: task.author.displayName,
                            onChange: onAuthorChange,
                            user:user
                          }}
                        />
                        {task.dateTimeTasks.length === 0 && task.author.id === user.id  ? (
                          <TableCell>
                              <Tooltip title="Перейти в календарь">
                                <IconButton
                                  onClick={() => { calendarOpen(task)}}
                                >
                                  <CalendarMonthIcon />
                                </IconButton>
                              </Tooltip>
                            {/* </TableCell> */}
                          </TableCell>
                        ) : (

                        task.dateTimeTasks.length >= 1 ? 
                        <TableCell>
                            <IconButton
                            aria-label="expand row"
                            size="small"
                            onClick={() => setOpen(!open)}
                          >
                            {open ? <KeyboardArrowUpIcon /> : <KeyboardArrowDownIcon />}
                          </IconButton>
                        </TableCell>
                        :

                          <CustomTableCell 
                            {...{
                              task,
                              name: "dateTimeStart",
                              value: moment(task.dateTimeTasks[0]?.dateTimeStart) 
                              .utc()
                              .format("DD/MM "),
                              value2:moment(task.dateTimeTasks[0]?.dateTimeStart)
                              .utc()
                              .format("kk:00")+" - "+
                              moment(task.dateTimeTasks[0]?.dateTimeDue)
                              .utc()
                              .format("kk:00"),
                               user:user
                            }}>
                          </CustomTableCell>
                        )}

                        {task.isEditMode && task.author.id===user.id  ? (
                          <TableCell>
                            <MaterialUIPickers
                            task={task}
                            name="dateTimeDeadLine"
                            onChange={onDateChange}
                            user={user}
                          />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "dateTimeDeadLine",
                              value: moment(task.dateTimeDeadLine
                                )
                              .utc()
                              .format("DD/MM kk:mm"),
                              user:user
                            }}
                          />
                        )}
                        {task.isEditMode ? (
                          <TableCell>
                            <BasicSelect
                              items={[
                                { value: "opened", title: "opened" },
                                { value: "done", title: "done" },
                                { value: "failed", title: "failed" },
                              ]}
                              task={task}
                              onChange={onChange}
                              name="accomplish"
                              value={task.accomplish}
                              user={user}
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "accomplish",
                              value: task.accomplish,
                              user:user
                            }}
                          />
                        )}

                        <TableCell>
                          <Tooltip title="Редактировать">
                            {task.isEditMode ? (
                              <IconButton
                                aria-label="done"
                                onClick={() => {
                                  onToggleEditModeDone(task.id);
                                  handleEditTask(task);
                                }}
                              >
                                <Done />
                              </IconButton>
                            ) : (
                              <IconButton
                                aria-label="edit"
                                onClick={() => onToggleEditMode(task.id)}
                              >
                                <Edit />
                              </IconButton>
                            )}
                          </Tooltip>
                        </TableCell>
                        {task.author.id===user.id  ?
                        (<TableCell>
                          <Tooltip title="Удалить">
                            <IconButton
                              onClick={(id) => {
                                deleteHandle(task.id);
                              }}
                            >
                              <DeleteIcon />
                            </IconButton>
                          </Tooltip>
                        </TableCell>):null}

                      </TableRow>
                      {task.dateTimeTasks.length>=1?          
        <TableRow>
          <TableCell style={{ paddingBottom: 0, paddingTop: 0 }} colSpan={11}>
            <Collapse in={open} timeout="auto" unmountOnExit>
              <Box sx={{ margin: 1 }}>
                <Typography variant="h6" gutterBottom component="div">
                  Расписание
                </Typography>
                <Table size="small" aria-label="purchases"   sx={{
                  backgroundColor: "#ebebeb"}}>
                  <TableHead>
                    <TableRow>
                      <TableCell colSpan={10} >Дата создания</TableCell>
                      <TableCell align="right">День недели</TableCell>
                      <TableCell align="right">Начало</TableCell>
                      <TableCell align="center" colSpan={1}>Окончание</TableCell>
                      <TableCell align="center" ></TableCell>
                      <TableCell align="center" ></TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {task.dateTimeTasks.map((dateTimeTask, index) => (
                      <TableRow key={index}>
                        <TableCell component="th" scope="row" colSpan={10}>
                          {moment(task.createdAt)
                              .utc()
                              .format("DD/MM")}
                        </TableCell>
                        <TableCell align="right">
                          {getDayOfWeek(dateTimeTask.dateTimeStart)}, {moment(dateTimeTask.dateTimeStart)
                              .utc()
                              .format("DD/MM")}
                          </TableCell>
                        <TableCell align="right">
                          {timeTransform(dateTimeTask.dateTimeStart)}
                          </TableCell>
                        <TableCell align="center" colSpan={1}>
                          {timeTransform(dateTimeTask.dateTimeDue)}
                        </TableCell>

                   
                        {/* delete option datetimeTask  */}
                        {task.author.id===user.id  ?
                        (<TableCell style={{width:'0%'}}>
                          <Tooltip title="Удалить Копию">
                            <IconButton
                              onClick={(id) => {
                                deleteDateTimeTask(dateTimeTask.id);
                              }}
                            >
                              <RemoveIcon />
                            </IconButton>
                          </Tooltip>
                        </TableCell>):null}


                      </TableRow>
                    ))}
                  </TableBody>
                </Table>
              </Box>
            </Collapse>
          </TableCell>
      </TableRow>
  :<></>}
        </>
    )
}


export default TableRowTask;
