import * as React from "react";
import {
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableRow,
  TableHead,
  IconButton,
  Tooltip,
  Typography,
  Divider,
} from "@mui/material";
import { useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { AddBox, Luggage } from "@mui/icons-material";
import moment from "moment";
import CustomTableCell from "./CustomTableCell";
import MaterialUIPickers from "./DateTimePicker/DateTimePicker";
import BasicSelect from "../UI/Select/Select";
import { addTask } from "../../store/actions/tasksActions";
import TaskModal from "./TaskModal/TaskModal";
import {dateToISOLikeButLocal} from '../../helpers/CalendarHelpers';

export default function NewTaskForm({ projects, setAddTaskForm }) {
  console.log('new task form')
  const dispatch = useDispatch();
  const user = useSelector((state) => state.users.user);
  const currentDateTime = new Date();
  const dateTime = moment(currentDateTime).utc().format();
  const [task, setTask] = useState({
    id: 0,
    title: "",
    description: "",
    createdAt: dateTime,
    dateTimeStart: null,
    dateTimeDeadLine: null,
    dateTimeTasks: [],
    dateTimeDue: null,
    project: null,
    accomplish: "opened",
    priority: "B",
    author: { id: user.id },
    // authorDisplayName: user.displayName,
    executor:null,
    isEditMode: true,
  });

  const [modal, setModal] = useState(false);

  const onModalOpen = (event, task) => {
    event.stopPropagation();
    setModal(true);
  };

  const handleClose = () => {
    setModal(false);
  };

  const onChange = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const newTask = { ...task, [name]: value };
    setTask(newTask);
  };

  const onProjectChange = (e, task) => {
    const value = e.target.value;
    const project = projects.find((e) => e.id === value);
    const newTask = { ...task };
    newTask.project = project;
    setTask(newTask);
  };

  const onDateChange = (id, value, property) => {
    const utcAvoidoffset = moment(value).utcOffset(0, true).format()
    const newTask = {
      ...task,
      [property]:     utcAvoidoffset,
      // [property]:     moment.parseZone(value, "DD/MM/YYYY", true).format(),
    };
    setTask(newTask); 
  };

  const handleAddTask = () => {
    console.log('handle task new form ', task)
    dispatch(addTask(task));
    setAddTaskForm();
  };

  return (
    <>
      <Divider>
        <Typography variant="overline">Добавить новую задачу</Typography>
      </Divider>
      <TableContainer
        style={{
          backgroundColor: "#E8E8E8",
          marginBottom: "2em",
        }}
      >
        <Table sx={{ minWidth: 600 }} aria-labelledby="tableTitle">
          <TableHead>
            <TableRow>
              {header.map((headCell) => (
                <TableCell
                  key={headCell.id}
                  align="left"
                  padding={headCell.disablePadding ? "none" : "normal"}
                  style={{ paddingLeft: "0" }}
                >
                  {headCell.label}
                </TableCell>
              ))}
            </TableRow>
          </TableHead>

          <TableBody>
            <TableRow hover key={task.id} style={{ paddingLeft: "40px" }}>
              <TableCell style={{ width: "40px", padding: "0" }}></TableCell>
              <TableCell style={{ width: "8%", paddingLeft: "0" }}>
                <BasicSelect
                  items={[
                    { value: "A", title: "A" },
                    { value: "B", title: "B" },
                    { value: "C", title: "C" },
                  ]}
                  task={task}
                  value={task.priority}
                  onChange={onChange}
                  name="priority"
                />
              </TableCell>

      

              <CustomTableCell
                {...{
                  task,
                  name: "title",
                  value: task.title,
                  onModalOpen,
                  user: user,
                  placeholder: "Кликните для ввода информации по задаче",
                  width: "auto",
                }}
              />

              <TableCell style={{ width: "15%", paddingLeft: "0" }}>
                <BasicSelect
                  items={projects.map((e) => ({
                    value: e?.id,
                    title: e?.title,
                  }))}
                  task={task}
                  onChange={onProjectChange}
                  name="project"
                  value={task.project?.id}
                />
              </TableCell>

              <TableCell style={{ width: "20%", paddingLeft: "0" }}>
                <MaterialUIPickers
                  task={task}
                  name="dateTimeDeadLine"
                  onChange={onDateChange}
                />
                {/* <DateTimePicker/> */}
              </TableCell>

              <TableCell style={{ width: "5%" }}>
                <Tooltip title="Добавить">
                  <IconButton size="large" onClick={handleAddTask}>
                    <AddBox fontSize="large" />
                  </IconButton>
                </Tooltip>
              </TableCell>
            </TableRow>
          </TableBody>
        </Table>
        <TaskModal
          task={task}
          open={modal}
          handleClose={handleClose}
          onChange={onChange}
          user={user}
        />
      </TableContainer>
      <Divider />
    </>
  );
}

export const header = [
  {
    id: "id",
    numeric: true,
    disablePadding: true,
    label: "",
  },
  {
    id: "priority",
    numeric: false,
    disablePadding: true,
    label: "Приоритет",
  },
  {
    id: "title",
    numeric: false,
    disablePadding: false,
    label: "Заголовок",
  },
  {
    id: "projectName",
    numeric: true,
    disablePadding: false,
    label: "Проект",
  },

  {
    id: "dateTimeDeadLine",
    numeric: true,
    disablePadding: false,
    label: "Дедлайн",
  },

  {
    id: "add",
    numeric: false,
    disablePadding: false,
    label: "",
  },
];
