import React, {useState} from "react";
import TextField from "@mui/material/TextField";
import { LocalizationProvider } from "@mui/x-date-pickers/LocalizationProvider";
import { DateTimePicker } from "@mui/x-date-pickers/DateTimePicker";
import { AdapterMoment } from "@mui/x-date-pickers/AdapterMoment";
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
import moment from "moment";





export default function MaterialUIPickers({task, name,onChange, }) {
  const [state, setState]=useState(null)
  let fullYear = new Date().getFullYear()
  let month = new Date().getMonth() 
  let day = new Date().getDate();
  console.log('datepicker inside task', task, 'state ', state)

  return (
    <LocalizationProvider
      dateAdapter={AdapterMoment}
      sx={{ width: "100%", fontSize: 5, fontWeight: "200" }}
      adapterLocale={'ru-RU'}
    >
      <DateTimePicker
      minTime={moment({year:fullYear,month:month,day:day ,hour:11,minute:0})}
      maxTime={moment({year:fullYear,month:month,day:day ,hour:20,minute:0})}
      disablePast={true}
      showTimeSelect={true}
      minutesStep={60}
      ampm={false}
      ampmInClock={false}
        inputFormat="DD/MM/YY HH:mm"
        disabled={task.readOnly}
        renderInput={(params) =>{  return (
          <TextField
            {...params}
            sx={{ width: "auto", fontWeight: "200", fontSize: 5 }}
            name={name}
          />
        )}}
        value={state}
        onChange={(newValue) => {
          setState(newValue)
          console.log('newValue ', newValue)
          onChange(task.id, newValue, name);
        }}
      />
    </LocalizationProvider>
  );
}
