export const getTasksWithInfoForPosition = (line, sortedTasks, linesInDay, columnDayHeight, hours) => {
  if (line) {
    const boxes = []
    for (let i = 0; i < line.length; i++) {
      if (!isNaN(line[i])) {
      } else {
        const task = sortedTasks[line[i].split('-')[1]]
        const taskIsThere = boxes.find((taskFind) => {
          if (taskFind?.task?.id === task.id) return taskFind
          return false
        })
        const step = columnDayHeight / hours.length
        if (taskIsThere) {
          taskIsThere.height += step
          let tasksInHour = 0
          for (let line of linesInDay) {
            if (isNaN(line[i])) {
              tasksInHour++
            }
          }
          if (tasksInHour > taskIsThere.tasksInHour) {
            taskIsThere.tasksInHour = tasksInHour
          }
        } else {
          let tasksInHour = 0
          for (let line of linesInDay) {
            if (isNaN(line[i])) {
              tasksInHour++
            }
          }
          boxes.push({
            tasksInHour: tasksInHour,
            top: step * i,
            height: step,
            task: sortedTasks[line[i].split('-')[1]]
          })
        }
      }
    }
    return boxes
  }
}


export const getWidthLeftZIndex = (task, dayColumnWidth, i) => {
  const amount = task.tasksInHour
  const oneTaskPrecentWidth = 100 / amount
  const left = oneTaskPrecentWidth * dayColumnWidth / 100 * i
  const zIndex = 10 + i
  const oneTaskWidth = dayColumnWidth - (oneTaskPrecentWidth * dayColumnWidth / 100) * i
  return { width: oneTaskWidth, left: left, zIndex: zIndex }
}