import { Button, TextField } from "@mui/material";
import { memo } from "react";
import { useSelector } from "react-redux";
import { priorities } from "../../../../constants";
import CustomSelect from '../../../UI/СustomSelect/СustomSelect'
import { isValidate } from "./Helpers";


function CalendarModalTaskContent({ title, onChangeCurrentTaskHandler, description, priority, project, sendNewTaskHandler, deleteTaskHandler, startHour, endHour, id }) {

  const { allUserProjectsForModalTask } = useSelector(state => state.projects)

  return (
    <>
      <TextField
        id="task-description-title"
        value={title}
        label="Название"
        variant="outlined"
        sx={{ marginBottom: '30px' }}
        name='title'
        onChange={(e) => { onChangeCurrentTaskHandler(e) }}
      />
      <TextField
        id="task-description"
        multiline
        rows={4}
        value={description}
        label="Описание"
        variant="outlined"
        sx={{ marginBottom: '30px' }}
        name='description'
        onChange={(e) => { onChangeCurrentTaskHandler(e) }}
      />
      <div style={{ display: 'flex', gap: '20px', margin: '20px 0' }}>
        <CustomSelect
          defaultValue={null}
          value={priority}
          name={'priority'}
          variant={'outlined'}
          onChange={(e) => { onChangeCurrentTaskHandler(e) }}
          label={'Приоритет'}
          id={'priority-type'}
          items={priorities}
        />
        <CustomSelect
          value={project}
          name={'project'}
          variant={'outlined'}
          onChange={(e) => { onChangeCurrentTaskHandler(e) }}
          label={'Проект'}
          id={'project'}
          items={allUserProjectsForModalTask}
        />
      </div>
      <div style={{ display: 'flex', gap: '20px', margin: '20px 0' }}>
        <TextField
          id="task-startHour"
          value={startHour}
          label="От"
          variant="outlined"
          name='startHour'
          onChange={(e) => { onChangeCurrentTaskHandler(e) }}
        />
        <TextField
          id="task-endHour"
          value={endHour}
          label="До"
          variant="outlined"
          name='endHour'
          onChange={(e) => { onChangeCurrentTaskHandler(e) }}
        />
      </div>
      <div style={{ display: 'flex', justifyContent: 'space-between', margin: '10px 0' }}>
        <Button id='test_button_save_task' onClick={sendNewTaskHandler} disabled={!isValidate(title, project, startHour, endHour, description)}>Сохранить</Button>
        <Button onClick={deleteTaskHandler} disabled={!id}>Удалить</Button>
      </div>
    </>);
}

export default memo(CalendarModalTaskContent);