import * as React from "react";
import {
  Box,
  Table,
  TableBody,
  TableContainer,
  TablePagination,
  Paper,
} from "@mui/material";
import { useState, useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import TaskModal from "../../components/UsersTasksCompoments/TaskModal/TaskModal";
import moment from "moment";
import UsersTaskToolBar from "../../components/UsersTasksCompoments/UsersTaskToolBar";
import { deleteTask, editTask, deleteDateTimeTask , fetchAllTasksByMembership} from "../../store/actions/tasksActions";
import NewTaskForm from "../../components/UsersTasksCompoments/NewTaskForm";
import TableRowTask from "../../components/UsersTasksCompoments/TableRowTask/TableRowTask";
import UsersTasksHeader from "./UsersTasksHeader/UsersTasksHeader";


export default function UsersTasks() {

  const dispatch = useDispatch();

  const tasks = useSelector((state) => state.tasks.tasks);
  const projects = useSelector((state) => state.tasks.projects);
  
  const user = useSelector((state) => state.users.user);
  const [executors, setExecutors]=useState([])
  // const [currentExecutor, setCurrentExecutor]= useState(task.executor.id?task.executor:'')
  const [currentProject, setCurrentProject] = useState(null);
  const [recievedTasks, setRecievedTasks] = useState([]);
  const [addTaskForm, setAddTaskForm] = useState(false);
  const [order, setOrder] = useState("asc");
  const [orderBy, setOrderBy] = useState("id");
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] =useState(25);
  const [modal, setModal] = useState({
    open: false,
    task: null,
  });
 
  
  useEffect(() => {
    dispatch(fetchAllTasksByMembership());
    if (tasks && tasks?.length > 0) {
      setRecievedTasks(tasks);
      }
  }, [dispatch,
     tasks?.length,
    addTaskForm, setAddTaskForm]);

  const handleRequestSort = ( property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  const handleChangePage = ( newPage) => {
    setPage(newPage);
  };

  const handleChangeRowsPerPage = (event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  };

  const onChange = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return { ...task, [name]: value };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };


  const onDateChange = (id, value, property) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          [property]: moment.parseZone(value, "DD/MM/YY", true).format(),
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };
  
  const onProjectChange = (e, task) => {
    const projectId = e.target.value;
      const project = projects.length>0 ?projects.find((uniqueProject) => uniqueProject.id === projectId):null;
      setCurrentProject(project)
      let executorList=[]
      if(project?.members){
        for (let member of project.members){
          executorList.push(member.user)
        }
      }
      setExecutors(executorList)
    
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        const updated = { ...task };
        updated.project = project;
        updated.projectName =project.title? project.title:null;
        return updated;
      }
        return task;
    });
    setRecievedTasks(newTasks);
  };

  const onExecutorChange = (e, task) => {
    const executorId = e.target.value;
    const executor = executors.find((executor) => executor.id === executorId);
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        const updated = { ...task };
        updated.executor = executor;
        updated.executorName = executor.displayName;
        return updated;
      }
        return task;
    });
    setRecievedTasks(newTasks);
  };





  const onToggleEditMode = (id) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          isEditMode: true,
          readOnly: false,
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onToggleEditModeDone = (id) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        console.log('toggledDone task ', task)
        return {
          ...task,
          isEditMode: false,
          readOnly: true,
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const handleEditTask= (task)=>{
     dispatch(editTask(task))
  }

  const deleteHandle = (id) => {
    dispatch(deleteTask(id));
  };

  const deleteDateTimeTaskHandle=(dateTimeTaskId)=>{
    console.log('delete by dateTimeTaskId ', dateTimeTaskId)
    dispatch(deleteDateTimeTask(dateTimeTaskId))
  }

  const onModalOpen = (event, task) => {
    event.stopPropagation();
    setModal({ ...modal, open: true, id: task.id });
  };

  const handleClose = () => {
    setModal({ ...modal, open: false, id: null });
  };
  // ++++++++фильтрация по проектам+++++++++++++++

  const [projectIdListForTaskSelect, setProjectIdListForTaskSelect] = React.useState([]);
  const [filterProjectTumbler, setFilterProjectTumbler] = React.useState(false);


  const onClose=(projectIdListForTaskSelect)=>{
    let tasksFilteredByProject = tasks
    if (projectIdListForTaskSelect.length>0) {
      tasksFilteredByProject = tasks.filter(task=>projectIdListForTaskSelect.includes(task.project?.id)) 
    }
    setRecievedTasks(tasksFilteredByProject)
    setFilterProjectTumbler(true)
  }
 
  // if (
  //   tasks &&
  //   tasks?.length > 0 &&
  //   recievedTasks &&
  //   recievedTasks?.length > 0
  // ) {
    return (
      <Box sx={{ width: "fullwidth" }}>
        <Paper sx={{ width: "100%", mb: 2 }}>
          <UsersTaskToolBar
            onClick={() => setAddTaskForm(!addTaskForm)}
            formStatus={addTaskForm}
            projects={projects}
            onClose={onClose}
            projectIdListForTaskSelect={projectIdListForTaskSelect}
            setProjectIdListForTaskSelect={setProjectIdListForTaskSelect}
          />

         {addTaskForm ? (
            <NewTaskForm
              projects={projects}
              setCurrentProject={setCurrentProject}
              currentProject={currentProject}
              setAddTaskForm={()=>setAddTaskForm(false)}
             />
          ) : null}


          <TableContainer>
            <Table sx={{ minWidth: 600 }} aria-labelledby="tableTitle" size='small'>
              <UsersTasksHeader
                order={order}
                orderBy={orderBy}
                onRequestSort={handleRequestSort}
                rowCount={recievedTasks.length}
              />
              <TableBody>
               
                {stableSort(recievedTasks, getComparator(order, orderBy))
                  .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                  .map((task, index) => {
                    return (
                      <TableRowTask
                      key ={index}
                      user={user}
                      task={task}
                      deleteHandle={deleteHandle}
                      handleEditTask ={handleEditTask}
                      deleteDateTimeTask={deleteDateTimeTaskHandle}
                      onChange={onChange}
                      onModalOpen={onModalOpen}
                      onProjectChange={onProjectChange}
                      executors={executors}
                      onExecutorChange={onExecutorChange}
                      uniqueProjects={projects}
                      onDateChange={onDateChange}
                      onToggleEditMode={onToggleEditMode}
                      onToggleEditModeDone={onToggleEditModeDone}
                      />
                    
                    );
                  })}
              </TableBody>
            </Table>
          </TableContainer>
          <TablePagination
            rowsPerPageOptions={[5, 10, 25]}
            component="div"
            count={recievedTasks.length}
            rowsPerPage={rowsPerPage}
            page={page}
            onPageChange={handleChangePage}
            onRowsPerPageChange={handleChangeRowsPerPage}
          />
        </Paper>
        <TaskModal
          task={recievedTasks.find((task) => task.id === modal.id)}
          open={modal.open}
          handleClose={handleClose}
          onChange={onChange}
          user={user}
        />
      </Box>
    );
  }
// }


function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
    return 1;
  }
  return 0;
}

function getComparator(order, orderBy) {
  return order === "desc"
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}

function stableSort(array, comparator) {
  const stabilizedThis = array?.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) {
      return order;
    }
    return a[1] - b[1];
  });
  return stabilizedThis.map((el) => el[0]);
}
