import React,{useState} from "react";
import {
  TableCell,
  TableRow,
  IconButton,
  Tooltip,
  Collapse,
  Box,
  Table,
  TableBody,
  TableHead,
  Typography
  
} from "@mui/material";
import { Done, Edit } from "@mui/icons-material";
import RemoveIcon from '@mui/icons-material/Remove';
import DeleteIcon from "@mui/icons-material/Delete";
import moment from "moment";
import CustomTableCell from "../CustomTableCell";
import MaterialUIPickers from "../DateTimePicker/DateTimePicker";
import BasicSelect from "../../UI/Select/Select";
import CalendarMonthIcon from '@mui/icons-material/CalendarMonth';
import KeyboardArrowDownIcon from '@mui/icons-material/KeyboardArrowDown';
import KeyboardArrowUpIcon from '@mui/icons-material/KeyboardArrowUp';
import { TaskStatuses } from "../../../helpers/TableTasksHelpers";

const weekDays = ["Вс","Пн","Вт","Ср","Чт","Пт","Сб" ];

const TableRowTask= ({
  user,
  task,
  deleteHandle,
  handleEditTask, 
  deleteDateTimeTask,
  onChange,
  onModalOpen,
  // onProjectChange,
  // onExecutorChange,
  uniqueProjects,
  // executors,
  onDateChange,
  onToggleEditMode,
  onToggleEditModeDone,
})=>{

  const [open, setOpen] = useState(false);
  const [defaultExecutor, setDefaultExecutor] = useState(task.executor?.id)
  const [executors, setExecutors]=useState([])
  const [currentProject, setCurrentProject] = useState(null);
  const [recievedTasks, setRecievedTasks] = useState([]);

  const roudHourUp =(dateIso)=>{
    let m = moment(dateIso);
    let roundUp = m.minute() || m.second() || m.millisecond() ? m.add(1, 'hour').startOf('hour') : m.startOf('hour');
    return roundUp
  }

  const timeTransform = (dateIso)=>{
    const exp  = roudHourUp(moment.utc(dateIso)).format("HH:"+"00")
    return exp;
  }
  
  const getDayOfWeek = (dateIso) => {
    const date = moment.utc(dateIso);
     return weekDays[date.day()];
  }



    const onProjectChange = (e, task) => {
      e.preventDefault()
      setDefaultExecutor(user)
    const projectId = e.target.value;
      const project = uniqueProjects.length>0 ?uniqueProjects.find((uniqueProject) => uniqueProject.id === projectId):null;
      console.log('change project ', project)
      setCurrentProject(project)
      let executorList=[]
      if(project?.members){
        for (let member of project.members){
          executorList.push(member.user)
        }
      }
      setExecutors(executorList)
    
    // const { id } = task;
    // const newTasks = recievedTasks.map((task) => {
    //   if (task.id === id) {
    //     const updated = { ...task };
    //     updated.project = project;
    //     updated.projectName =project.title? project.title:null;
    //     return updated;
    //   }
      task.project = project;
      task.projectName=project.title? project.title:null;

        return task;
    // });
    // setRecievedTasks(newTasks);
  };


  const onExecutorChange = (e, task) => {
    const executorId = e.target.value;
    const executor = executors.find((executor) => executor.id === executorId);
    // const { id } = task;
    // const newTasks = recievedTasks.map((task) => {
    //   if (task.id === id) {
    //     const updated = { ...task };
    //     updated.executor = executor;
    //     updated.executorName = executor.displayName;
    //     return updated;
    //   }
    //     return task;
    // });
    // setRecievedTasks(newTasks);


    task.executor = executor;
    task.executorName = executor.displayName;

      return task;
  };



    return (
        <>
         <TableRow hover key={task.id}>
       
                          <TableCell
                          component="th"
                          scope="row"
                          padding="none"
                        ></TableCell> 
                       
                        {task.isEditMode && task.author.id===user.id  ? (
                          <TableCell>
                            <BasicSelect
                              items={[
                                { value: "A", title: "A" },
                                { value: "B", title: "B" },
                                { value: "C", title: "C" },
                              ]}
                              task={task}
                              value={task.priority}
                              onChange={onChange}
                              name="priority"
                              user={user}
                            />

                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "priority",
                              value: task.priority,
                              user:user
                            }}
                          />
                        )}

                        <CustomTableCell
                          {...{
                            task,
                            name: "createdAt",
                            value: moment(task.createdAt)
                              .utc()
                              .format("DD-MM-YY"),
                              user:user
                          }}
                        />

                        <CustomTableCell
                          {...{
                            task,
                            name: "title",
                            value: task.title,
                            onChange,
                            onModalOpen,
                            user:user
                          }}
                        />
                       
                       {task.isEditMode && task.author.id===user.id  ? (
                          <TableCell>
                            <BasicSelect
                              items={uniqueProjects.map((e) => ({
                                value: e?.id,
                                title: e?.title,
                              }))}
                              task={task}
                              onChange={onProjectChange}
                              name="project"
                              value={task.project?.id}
                              user={user}
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "projectId",
                              value: task.project?.title,
                              user:user
                            }}
                          />
                        )}

                              {/* executor cell display */}
                              {/* executor cell display */}
                              {/* executor cell display */}
                              {/* executor cell display */}
                        {task.isEditMode && task.author.id===user.id  ? (
                          <TableCell>
                            <BasicSelect
                              items={executors.map((e) => ({
                                value: e?.id,
                                title: e?.displayName,
                              }))}
                              task={task}
                              onChange={onExecutorChange}
                              name="executor"
                              defaultValue={defaultExecutor?.id}
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "executor",
                              value: task.executor?.displayName,
                              user:user
                            }}
                          />
                        )}



                        <CustomTableCell
                          {...{
                            task,
                            name: "author",
                            value: task.author.displayName,
                            user:user
                          }}
                        />
                        {task.isEditMode && task.author.id===user.id  ? (
                          <TableCell>
                          <Tooltip title="Перейти в календарь">
                            <IconButton
                              onClick={(id) => { deleteHandle(task.id);}}
                            >
                              <CalendarMonthIcon />
                            </IconButton>
                          </Tooltip>
                          </TableCell>
                        ) : (

                        task.dateTimeTasks.length>1 ? 
                        <TableCell>
                            <IconButton
                            aria-label="expand row"
                            size="small"
                            onClick={() => setOpen(!open)}
                          >
                            {open ? <KeyboardArrowUpIcon /> : <KeyboardArrowDownIcon />}
                          </IconButton>
                        </TableCell>
                        :

                          <CustomTableCell
                            {...{
                              task,
                              name: "dateTimeStart",
                              value: moment(task.dateTimeTasks[0]?.dateTimeStart) 
                              .utc()
                              .format("DD-MM-YY "),
                              value2:moment(task.dateTimeTasks[0]?.dateTimeStart)
                              .utc()
                              .format("kk:mm")+" - "+
                              moment(task.dateTimeTasks[0]?.dateTimeDue)
                              .utc()
                              .format("kk:mm"),
                               user:user
                            }}>
                          </CustomTableCell>
                        
                          
                        )}

                        {task.isEditMode && task.author.id===user.id  ? (
                          <TableCell>
                            <MaterialUIPickers
                            task={task}
                            name="dateTimeDue"
                            onChange={onDateChange}
                            user={user}
                          />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "dateTimeDeadLine",
                              value: moment(task.dateTimeDeadLine
                                )
                              .utc()
                              .format("DD-MM-YY kk:mm"),
                              user:user
                            }}
                          />
                        )}
                        {task.isEditMode ? (
                          <TableCell>
                            <BasicSelect
                              items={[
                                { value: "opened", title: "создано" },
                                { value: "done", title: "выполнено" },
                                { value: "failed", title: "просрочено" },
                                { value: "progress", title: "в работе" },
                                { value: "cancelled", title: "отменено" },
                              ]}
                              task={task}
                              onChange={onChange}
                              name="accomplish"
                              value={task.accomplish}
                              user={user}
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "accomplish",
                              value: TaskStatuses[task.accomplish],
                              user:user
                            }}
                          />
                        )}

                        <TableCell>
                          <Tooltip title="Редактировать">
                            {task.isEditMode ? (
                              <IconButton
                                aria-label="done"
                                onClick={() => {
                                  onToggleEditModeDone(task.id);
                                  handleEditTask(task);
                                }}
                              >
                                <Done />
                              </IconButton>
                            ) : (
                              <IconButton
                                aria-label="edit"
                                onClick={() => onToggleEditMode(task.id)}
                              >
                                <Edit />
                              </IconButton>
                            )}
                          </Tooltip>
                        </TableCell>
                        {task.author.id===user.id  ?
                        (<TableCell>
                          <Tooltip title="Удалить">
                            <IconButton
                              onClick={(id) => {
                                deleteHandle(task.id);
                              }}
                            >
                              <DeleteIcon />
                            </IconButton>
                          </Tooltip>
                        </TableCell>):null}

                      </TableRow>
                      {task.dateTimeTasks.length>1?          
        <TableRow>
          <TableCell style={{ paddingBottom: 0, paddingTop: 0 }} colSpan={11}>
            <Collapse in={open} timeout="auto" unmountOnExit>
              <Box sx={{ margin: 1 }}>
                <Typography variant="h6" gutterBottom component="div">
                  Расписание
                </Typography>
                <Table size="small" aria-label="purchases"   sx={{
                  backgroundColor: "#ebebeb"}}>
                  <TableHead>
                    <TableRow>
                      <TableCell colSpan={10} >Дата создания</TableCell>
                      <TableCell align="right">День недели</TableCell>
                      <TableCell align="right">Начало</TableCell>
                      <TableCell align="center" colSpan={1}>Окончание</TableCell>
                      <TableCell align="center" ></TableCell>
                      <TableCell align="center" ></TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {task.dateTimeTasks.map((dateTimeTask, index) => (
                      <TableRow key={index}>
                        <TableCell component="th" scope="row" colSpan={10}>
                          {moment(task.createdAt)
                              .utc()
                              .format("DD/MM")}
                        </TableCell>
                        <TableCell align="right">
                          {getDayOfWeek(dateTimeTask.dateTimeStart)}, {moment(dateTimeTask.dateTimeStart)
                              .utc()
                              .format("DD/MM")}
                          </TableCell>
                        <TableCell align="right">
                          {timeTransform(dateTimeTask.dateTimeStart)}
                          </TableCell>
                        <TableCell align="center" colSpan={1}>
                          {timeTransform(dateTimeTask.dateTimeDue)}
                        </TableCell>

                        {/* Edit option datetimeTask */}
                    <TableCell 
                    // style={{width:'0%'}}
                    >
             
                        </TableCell >
                        
                        {/* delete option datetimeTask  */}
                        {task.author.id===user.id  ?
                        (<TableCell style={{width:'0%'}}>
                          <Tooltip title="Удалить Копию">
                            <IconButton
                              onClick={(id) => {
                                deleteDateTimeTask(dateTimeTask.id);
                              }}
                            >
                              <RemoveIcon />
                            </IconButton>
                          </Tooltip>
                        </TableCell>):null}


                      </TableRow>
                    ))}
                  </TableBody>
                </Table>
              </Box>
            </Collapse>
          </TableCell>
      </TableRow>
  :<></>}
        </>
    )
}


export default TableRowTask;
