import { Grid, Typography, Button, Card, CardContent } from "@mui/material";
import { memo } from "react";
import ProjectsList from "./ProjectsList/ProjectsList";


const style = {
  display: 'flex',
  justifyContent: 'space-between',
  alignItems: 'center',
  marginBottom: '10px',
}

const ProjectsWrapper = ({ onClickProjectHandler, projects, onClickGoToSpecificProjectHandler, handleOpen, deleteProjectHandler }) => {


  return <>

    <Grid item xs={4}>
      <Typography variant="h2" sx={style}>
        Проекты
        <Button variant="outlined" onClick={()=>{handleOpen()}}>Создать</Button>
      </Typography>
      <ProjectsList 
        projects={projects} 
        onClickProjectHandler={onClickProjectHandler} 
        onClickGoToSpecificProjectHandler={onClickGoToSpecificProjectHandler}
        deleteProjectHandler={deleteProjectHandler}
      />
    </Grid>

  </>
};

export default memo(ProjectsWrapper);