import {Box} from "@mui/material";
import { memo } from "react";
import ProjectItem from "./ProjectItem/ProjectItem";

const style = {height: '79vh', overflow: 'auto', overflowX: 'hidden', display: 'flex', flexDirection: 'column', gap: '10px'}

const ProjectsList = ({projects, onClickProjectHandler, onClickGoToSpecificProjectHandler, deleteProjectHandler}) => {
    return (
        <Box sx={style}>
            {projects?.map(project => {
                return <ProjectItem
                    title={project.title}
                    members={project.members}
                    key={project.id}
                    onClickProjectHandler={()=>{onClickProjectHandler(project)}}
                    onClickGoToSpecificProjectHandler={(e)=>{onClickGoToSpecificProjectHandler(e, project.id)}}
                    deleteProjectHandler={(e)=>{deleteProjectHandler(e, project.id)}}
                />
            })}
        </Box>
    );
};

export default memo(ProjectsList);