import {Box, Grid, Typography } from "@mui/material";
import { useSelector } from "react-redux";
import { memo, useMemo } from "react";
import DeleteButton from "../../../../UI/DeleteButton/DeleteButton";
import ArrowIncrementButton from "../../../../UI/ArrowIncrementButton/ArrowIncrementButton";

const styleBlock = {
    border: '2px solid black',
    borderRadius: '5px',
    width: '92%',
    padding: '10px',
    display: 'flex', 
    justifyContent: 'space-between',
    alignItems: 'center'
}

const styleText = {
    fontSize: '15px',
    fontWeight: '600',
}

const ProjectItem = ({ title, members, onClickProjectHandler, onClickGoToSpecificProjectHandler, deleteProjectHandler }) => {

    const { user } = useSelector(state => state.users);
    const currentRoleInProject = useMemo(() => {
        return members.find((member) => member.user.id === user.id)?.roleProject
    }, [members, user.id])

    return <>
        <Box onClick={onClickProjectHandler} sx={styleBlock}>
            <Box>
                <Typography sx={styleText}>
                    Проект: {title}
                </Typography>
                <Typography sx={styleText}>
                    Роль в проекте: {currentRoleInProject}
                </Typography>
            </Box>
            <Box>
                {currentRoleInProject === 'admin' ? <DeleteButton onClick={deleteProjectHandler}/> : null}
                <ArrowIncrementButton onClick={onClickGoToSpecificProjectHandler}/>
            </Box>
        </Box>
    </>
};

export default memo(ProjectItem);
